<?php

namespace App\Enums;

enum PostType: int
{
    use EnumTrait;

    case FEED = 0;
    case REELS = 1;
    case STORY = 2;
    case SHORTS = 3;

    public static function fromString(string $value): self
    {
        return match (strtolower($value)) {
            'feed' => self::FEED,
            'reels' => self::REELS,
            'story' => self::STORY,
            'shorts' => self::SHORTS,
            default => self::FEED,
        };
    }

}
