<?php

namespace App\Http\Controllers;

use App\Models\AiSetting;
use Illuminate\Http\Request;

class AiSettingController extends Controller
{
    public function AiConfigStore(Request $request)
    {
        
        $request->validate([
            'module' => 'required|string',
            'provider' => 'nullable|string',
            'config' => 'required|array',
        ]);


        AiSetting::updateOrCreate(
            ['module' => $request->input('module'), 'provider' => $request->input('provider')],
            ['config' => $request->input('config')]
        );

        return back()->with('success', 'Settings updated successfully.');
    }
}
