<?php

namespace App\Http\Middleware;

use App\Enums\StatusEnum;
use App\Models\Core\Language;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Symfony\Component\HttpFoundation\Response;

class SetLocale
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $locale = session('locale');


        if (!$locale) {
            $locale = config('app.locale');
        }

        App::setLocale($locale);

        session(['locale' => $locale]);

        return $next($request);
    }
}
