<?php

namespace App\Models;

use App\Models\Core\File;
use App\Traits\Filterable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class PostTemplate extends Model
{
    use Filterable;

    protected $guarded = [];

    protected static function booted()
    {

        static::creating(function (Model $model) {
            $model->uid = Str::uuid();
        });

    }

    public function platform()
    {
        return $this->belongsTo(Platform::class);
    }

    public function files()
    {
        return $this->belongsToMany(File::class, 'post_template_files')
            ->withPivot(['caption', 'alt', 'order'])
            ->withTimestamps();
    }
}
