<?php

namespace App\Models;

use App\Models\Core\File;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class SocialTemplate extends Model
{
    protected $fillable = [
        'uid',
        'created_by',
        'name',
        'slug',
        'description',
        'content',
        'platform_id',
        'post_type',
        'status'
    ];

    protected static function booted(){

        static::creating(function (Model $model) {
            $model->uid        = Str::uuid();
        });
      
    }

    public function platform()
    {
        return $this->belongsTo(Platform::class);
    }

    public function files()
    {
        return $this->morphMany(File::class, 'fileable');
    }
}
