<?php

namespace App\Models;

use App\Models\Core\File;
use Illuminate\Database\Eloquent\Model;

class UserFilePlatform extends Model
{
    protected $fillable = ['file_id', 'user_id', 'platform_id', 'type'];

    public function file()
    {
        return $this->belongsTo(File::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function platform()
    {
        return $this->belongsTo(Platform::class);
    }
}
