<?php

namespace App\Policies;

use Spatie\Csp\Directive;
use Spatie\Csp\Policy;


class CustomCspPolicy extends Policy
{
    /**
     * Create a new policy instance.
     */
    public function __construct()
    {
        // Custom initialization if needed
    }

    /**
     * Configure the CSP for the application.
     */
    public function configure()
    {
        $this->add(Directive::DEFAULT, "'self'");

        $nonce = app('csp-nonce');


        $this->add(Directive::STYLE, [
            "'self'",
            "'nonce-{$nonce}'",
            "'unsafe-inline'",
            'https://www.gstatic.com/',
            'https://www.gstatic.com/charts/49/css/util/util.css',
        ]);

        $this->add(Directive::SCRIPT, [
            "'self'",
            "'nonce-{$nonce}'",
            'https://www.google.com',
            'https://www.gstatic.com/',
            'https://www.gstatic.com/charts/geochart/10/info/mapList.js',
        ]);

        $this->add(Directive::IMG, [
            "'self'",
            '*',
            'data:',
            'blob:',
        ]);

        $this->add(Directive::FONT, [
            "'self'",
            'https://fonts.gstatic.com',
            'https://fonts.googleapis.com',
        ]);

        $this->add(Directive::MEDIA, '*');

        $this->add(Directive::FRAME, [
            "'self'",
            'https://checkout.paystack.com',
            'https://*.paypal.com',
        ]);

        $this->add(Directive::CONNECT, [
            "'self'",
            'https://www.gstatic.com/',
            'https://*.paypal.com',
        ]);

        $this->add(Directive::OBJECT, "'none'");
    }
}
