<?php

namespace Database\Seeders;

use App\Models\Account;
use App\Models\Platform;
use App\Models\SocialAccount;
use App\Models\Workspace;
use Illuminate\Database\Seeder;

class AccountSeeder extends Seeder
{
    public function run(): void
    {
        // NOTE: This seeder creates demo/test social accounts
        // It should NOT be run during production installation
        // Only use for testing/development purposes
        
        $workspace = Workspace::default()->first();

        Platform::all()->each(function ($platform) use ($workspace) {
            SocialAccount::factory()
                ->count(rand(5, 6))
                ->create([
                    'platform_id' => $platform->id,
                    'workspace_id' => $workspace->id,
                ]);
        });
    }
}
