<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class DemoSeeder extends Seeder
{
    /**
     * Run the demo data seeders.
     *
     * This seeder should be run MANUALLY after installation
     * to populate the database with demo data for presentations.
     *
     * Usage: php artisan db:seed --class=DemoSeeder
     */
    public function run(): void
    {
        $this->command->info('🌱 Starting demo data seeding...');
        $this->command->info('');

        $this->call([
            DemoUserSeeder::class,
            DemoSocialAccountSeeder::class,
            DemoTemplateSeeder::class,
            DemoAiTemplateSeeder::class,
            DemoPostSeeder::class,
            DemoAnalyticsSeeder::class,
        ]);

        $this->command->info('');
        $this->command->info('✅ Demo data seeding completed successfully!');
        $this->command->info('');
        $this->command->info('📋 Demo Credentials:');
        $this->command->info('   Admin: admin@postuno.com / password123');
        $this->command->info('   Manager: john@postuno.com / password123');
        $this->command->info('   Editor: sarah@postuno.com / password123');
        $this->command->info('   Editor: mike@postuno.com / password123');
        $this->command->info('   Viewer: emma@postuno.com / password123');
        $this->command->info('   Viewer: david@postuno.com / password123');
        $this->command->info('');
        $this->command->info('📊 Data Generated:');
        $this->command->info('   • 6 demo users with different roles');
        $this->command->info('   • 60-90 social media accounts');
        $this->command->info('   • 300-1800 social posts with metrics');
        $this->command->info('   • 100+ content templates');
        $this->command->info('   • 150+ AI templates');
        $this->command->info('   • 10 marketing campaigns');
        $this->command->info('   • 90 days of analytics data');
        $this->command->info('');
        $this->command->info('🎯 Your demo environment is ready!');
    }
}