import { ErrorValue, FormDataErrors, FormDataKeys, FormDataType, FormDataValues, Method, Progress, UrlMethodPair, VisitOptions } from '@inertiajs/core';
export type SetDataByObject<TForm> = (data: Partial<TForm>) => void;
export type SetDataByMethod<TForm> = (data: (previousData: TForm) => TForm) => void;
export type SetDataByKeyValuePair<TForm> = <K extends FormDataKeys<TForm>>(key: K, value: FormDataValues<TForm, K>) => void;
export type SetDataAction<TForm extends Record<any, any>> = SetDataByObject<TForm> & SetDataByMethod<TForm> & SetDataByKeyValuePair<TForm>;
type FormOptions = Omit<VisitOptions, 'data'>;
type SubmitArgs = [Method, string, FormOptions?] | [UrlMethodPair, FormOptions?];
type TransformCallback<TForm> = (data: TForm) => object;
export interface InertiaFormProps<TForm extends object> {
    data: TForm;
    isDirty: boolean;
    errors: FormDataErrors<TForm>;
    hasErrors: boolean;
    processing: boolean;
    progress: Progress | null;
    wasSuccessful: boolean;
    recentlySuccessful: boolean;
    setData: SetDataAction<TForm>;
    transform: (callback: TransformCallback<TForm>) => void;
    setDefaults(): void;
    setDefaults<T extends FormDataKeys<TForm>>(field: T, value: FormDataValues<TForm, T>): void;
    setDefaults(fields: Partial<TForm>): void;
    reset<K extends FormDataKeys<TForm>>(...fields: K[]): void;
    clearErrors<K extends FormDataKeys<TForm>>(...fields: K[]): void;
    resetAndClearErrors<K extends FormDataKeys<TForm>>(...fields: K[]): void;
    setError<K extends FormDataKeys<TForm>>(field: K, value: ErrorValue): void;
    setError(errors: FormDataErrors<TForm>): void;
    submit: (...args: SubmitArgs) => void;
    get: (url: string, options?: FormOptions) => void;
    patch: (url: string, options?: FormOptions) => void;
    post: (url: string, options?: FormOptions) => void;
    put: (url: string, options?: FormOptions) => void;
    delete: (url: string, options?: FormOptions) => void;
    cancel: () => void;
}
export default function useForm<TForm extends FormDataType<TForm>>(initialValues?: TForm | (() => TForm)): InertiaFormProps<TForm>;
export default function useForm<TForm extends FormDataType<TForm>>(rememberKey: string, initialValues?: TForm | (() => TForm)): InertiaFormProps<TForm>;
export {};
