import { ComponentPropsWithoutRef } from 'react';
import { DateOption } from 'flatpickr/dist/types/options';
import { FC } from 'react';
import flatpickr from 'flatpickr';
import { Options } from 'flatpickr/dist/types/options';
import { ReactNode } from 'react';
import { Ref } from 'react';

export declare type Callback = (arg0?: flatpickr.Instance | null) => void;

declare const DateTimePicker: FC<DateTimePickerProps>;
export default DateTimePicker;

export declare interface DateTimePickerHandle {
    flatpickr?: flatpickr.Instance;
}

export declare interface DateTimePickerProps
extends Omit_2<ComponentPropsWithoutRef<'input'>, 'children' | 'value' | 'onChange'> {
    defaultValue?: string;
    options?: OptionsType;
    onChange?: flatpickr.Options.Hook[] | flatpickr.Options.Hook;
    onOpen?: flatpickr.Options.Hook[] | flatpickr.Options.Hook;
    onClose?: flatpickr.Options.Hook[] | flatpickr.Options.Hook;
    onMonthChange?: flatpickr.Options.Hook[] | flatpickr.Options.Hook;
    onYearChange?: flatpickr.Options.Hook[] | flatpickr.Options.Hook;
    onReady?: flatpickr.Options.Hook[] | flatpickr.Options.Hook;
    onValueUpdate?: flatpickr.Options.Hook[] | flatpickr.Options.Hook;
    onDayCreate?: flatpickr.Options.Hook[] | flatpickr.Options.Hook;
    onCreate?: Callback;
    onDestroy?: Callback;

    value?: DateOption | DateOption[];
    children?: ReactNode;
    className?: string;
    ref?: Ref<DateTimePickerHandle | undefined>;

    render?: (props: any, handleNodeChange: (node: HTMLElement | null) => void) => ReactNode;
}

declare type Omit_2<T, K extends keyof any> = Pick<T, Exclude<keyof T, K>>;
export { Omit_2 as Omit }

export declare type OptionsType = {
    [k in keyof Options]?: Options[k];
};

export { }
