<?php

use Illuminate\Http\Request;

define('LARAVEL_START', microtime(true));

// Clean any output buffer to prevent JSON errors on shared hosting
if (ob_get_level()) {
    ob_end_clean();
}

// Start clean output buffering
ob_start();

// Determine if the application is in maintenance mode...
if (file_exists($maintenance = __DIR__.'/../storage/framework/maintenance.php')) {
    require $maintenance;
}

// Register the Composer autoloader...
require __DIR__.'/../vendor/autoload.php';

// Bootstrap Laravel and handle the request...
(require_once __DIR__.'/../bootstrap/app.php')
    ->handleRequest(Request::capture());

// Clean output buffer
if (ob_get_level()) {
    ob_end_flush();
}