import useTranslate from "@/hooks/useTranslate";

const AccountPerformanceChart = ({ data }) => {
  const accountsData = data?.accounts || []
  const t = useTranslate()

  return (
    <div className="bg-white dark:bg-zinc-900 rounded-lg border border-gray-200 dark:border-zinc-800 flex flex-col">
      <div className="p-6 pb-0">
        <h3 className="text-lg font-semibold text-gray-900 dark:text-white">{t("Accounts Performance")}</h3>
        <p className="text-sm text-gray-600 dark:text-gray-400 mt-1">
          {t("Track follower growth and engagement metrics")}
        </p>
      </div>

      <div className="p-6 pt-4 h-[28rem] overflow-y-auto scrollbar-thin scrollbar-thumb-gray-300 dark:scrollbar-thumb-zinc-700 scrollbar-track-transparent">
        <div className="space-y-4">
        {accountsData.map((account, index) => (
          <div key={index} className="space-y-6">
            {/* Account name and metrics */}
            <div className="flex items-center justify-between">
              <span className="text-sm text-gray-600 dark:text-gray-400 font-medium">{account.name}</span>
              <div className="flex items-center space-x-4 text-sm text-gray-600 dark:text-gray-400">
                <span className="font-medium">{account.followers}</span>
                <span className="font-medium">{account.percentage}%</span>
              </div>
            </div>

            {/* Progress bar */}
            <div className="relative">
              <div className="w-full bg-gray-200 dark:bg-zinc-700 rounded-full h-3">
                <div
                  className="bg-primary h-3 rounded-full relative transition-all duration-300"
                  style={{ width: `${account.value}%` }}
                >
                  {/* White circle indicator at the end */}
                  <div className="absolute right-0 top-1/2 transform translate-x-1/2 -translate-y-1/2 w-4 h-4 bg-white border-2 border-primary rounded-full"></div>
                </div>
              </div>
            </div>
          </div>
        ))}
        </div>
      </div>
    </div>
  )
}

export default AccountPerformanceChart
