"use client"

import { useState } from "react"
import PlatformIcon from "@/Components/UI/PlatformIcon"
import PostReaction from "@/Components/UI/PostReaction"
import useTranslate from "@/hooks/useTranslate";
import { Avatar, AvatarFallback, AvatarImage } from "@/Components/UI/Avatar"

const AllContent = ({ data = {} }) => {
  const [activeTab, setActiveTab] = useState("Post")

  const { posts = [] } = data
  const t = useTranslate()




  const filteredPosts = posts.filter((post) => post.type === activeTab.toLowerCase())

  const tabs = ["Post", "Reels", "Story"]

  return (
    <div className="bg-white dark:bg-zinc-900 rounded-lg p-6 shadow-sm border border-gray-200 dark:border-zinc-800">
      {/* Header with title and tabs */}
      <div className="flex justify-between items-center mb-6">
        <h3 className="text-lg font-semibold text-gray-900 dark:text-white">{t("All Content")}</h3>

        {/* Tabs */}
        <div className="flex space-x-1">
          {tabs.map((tab) => (
            <button
              key={tab}
              onClick={() => setActiveTab(tab)}
              className={`px-4 py-2 rounded-lg text-sm font-medium transition-colors ${activeTab === tab
                ? "bg-gradient-to-r from-primary to-secondary hover:bg-gradient-to-r hover:from-secondary hover:to-primary text-white"
                : "text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-zinc-800"
                }`}
            >
              {tab}
            </button>
          ))}
        </div>
      </div>

      {/* Content table */}
      <div className="min-h-[300px]">
        {/* Content rows */}
        <div className="space-y-4">
          {filteredPosts.map((post, index) => (
            <div key={post.id}>
              <div className="flex flex-col md:flex-row items-start md:space-x-4 space-y-4 md:space-y-0 py-4">
                {/* Left side - Author info with post content */}
                <div className="flex items-center space-x-3 flex-shrink-0 w-full md:w-[300px]">
                  <div className="relative flex-shrink-0">
                    <Avatar className="h-10 w-10">
                      <AvatarImage src={post?.account?.avatar} alt="User Avatar" />
                      <AvatarFallback>AV</AvatarFallback>
                    </Avatar>
                    <div className="absolute -bottom-1 -right-1 w-5 h-5 bg-white dark:bg-zinc-900 rounded-full flex items-center justify-center text-xs">
                      <PlatformIcon slug={post.platform?.slug} size={14} round={true} />
                    </div>
                  </div>
                  <div className="min-w-0 flex-1">
                    <p className="font-medium text-gray-900 dark:text-white text-sm truncate">{post.author}</p>
                    <p className="text-xs text-gray-500 dark:text-gray-400 mb-1">{post.timestamp}</p>
                    <div className="flex items-center space-x-2">
                      <p className="text-sm text-gray-600 dark:text-gray-300 truncate flex-1">{post.content}</p>
                    </div>
                  </div>

                  {/* Content and thumbnail */}
                  <div className="flex-1 flex items-center min-w-0">
                    {post.media && post.media.length > 0 && (
                      <div className="flex items-center gap-1">
                        {post.media.slice(0, 1).map((item) =>
                          item.isVideo ? (
                            <video
                              key={item.id}
                              src={item.thumbnail || "/placeholder.mp4"}
                              className="w-16 h-12 rounded object-cover"
                              muted
                              playsInline
                              loop
                              autoPlay
                            />
                          ) : (
                            <img
                              key={item.id}
                              src={item.url || "/placeholder.svg"}
                              alt={item.alt || "Post thumbnail"}
                              className="w-28 h-16 rounded object-cover"
                            />
                          )
                        )}

                        {post.media.length > 1 && (
                          <span className="text-xs font-semibold text-gray-700 dark:text-gray-300 ml-1">
                            +{post.media.length - 1}
                          </span>
                        )}
                      </div>
                    )}
                  </div>
                </div>

                {/* Right side - Metrics with labels */}
                <div className="flex-1 w-full">
                  <div className="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-5 lg:grid-cols-9 gap-4">
                    {[
                      ["Impression", post.metrics.impression],
                      ["Engagement", post.metrics.engagement],
                      ["Clicks", post.metrics.clicks],
                      ["Shares", post.metrics.shares],
                      ["Comments", post.metrics.comments],
                      ["Conversions", post.metrics.conversions],
                      ["Bounce Rate", post.metrics.bounceRate],
                      ["New Followers", post.metrics.newFollowers],
                      ["Revenue", post.metrics.revenue],
                    ].map(([label, value], i) => (
                      <div key={i} className="text-start">
                        <p className="text-xs text-gray-500 dark:text-gray-400 mb-1">{label}</p>
                        <p className="font-medium text-gray-900 dark:text-white text-sm">{value}</p>
                      </div>
                    ))}
                  </div>
                </div>
              </div>

              {index < filteredPosts.length - 1 && (
                <div className="border-b border-gray-200 dark:border-zinc-800"></div>
              )}
            </div>

          ))}
        </div>

        {/* Show message if no posts - with consistent height */}
        {filteredPosts.length === 0 && (
          <div className="text-center py-16">
            <p className="text-gray-500 dark:text-gray-400">No {activeTab.toLowerCase()} content found</p>
          </div>
        )}
      </div>
    </div>
  )
}

export default AllContent
