import { Download } from "lucide-react"

const AudienceByAge = ({ data = [] }) => {
  const maxValue = 80 // Maximum value for the chart scale

  return (
    <div className="bg-white dark:bg-zinc-900 rounded-lg border border-gray-200 dark:border-zinc-800 shadow-sm p-6">
      {/* Header */}
      <div className="flex items-center justify-between flex-wrap gap-4 mb-6">
        <h3 className="text-lg font-semibold text-gray-900 dark:text-gray-100">Audience by Age</h3>
        <button className="p-2 hover:bg-gray-100 rounded-md transition-colors">
          <Download className="w-4 h-4 text-gray-600" />
        </button>
      </div>

      {/* Chart */}
      <div className="space-y-4">
        {data.map((item, index) => (
          <div key={index} className="flex items-center">
            {/* Age Range Label */}
            <div className="w-12 text-sm text-gray-700 font-medium">{item.ageRange}</div>

            {/* Bar Container */}
            <div className="flex-1 ml-4 relative">
              <div className="w-full bg-gray-100 dark:bg-zinc-800 rounded-md h-8 relative overflow-hidden">
                {/* Progress Bar */}
                <div
                  className="h-full rounded-md flex items-center justify-start pl-3 transition-all duration-300"
                  style={{
                    width: `${(item.percentage / maxValue) * 100}%`,
                    background: `linear-gradient(90deg, #1E90FF 0%, #00BFFF 100%)`,
                  }}
                >
                  <span className="text-white text-sm font-medium">{item.percentage}%</span>
                </div>
              </div>
            </div>
          </div>
        ))}
      </div>

      {/* X-axis Scale */}
      <div className="flex justify-between mt-4 ml-16 text-xs text-gray-500">
        <span>0</span>
        <span>20</span>
        <span>40</span>
        <span>60</span>
        <span>80</span>
      </div>
    </div>
  )
}

export default AudienceByAge
