"use client"

import { Download } from "lucide-react"
import { Chart } from "react-google-charts"

export default function GeoDistribution({ data = {} }) {
  const { countries = [], statistics = [] } = data

  const mapOptions = {
    colorAxis: {
      colors: ["#e8f5e8", "#4ade80", "#10b981", "#059669"],
      minValue: 60,
      maxValue: 200,
    },
    backgroundColor: "transparent",
    datalessRegionColor: "#f3f4f6",
    defaultColor: "#f3f4f6",
    legend: "none",
    tooltip: { isHtml: true },
  }

  const leftColumnStats = statistics.filter((stat) => stat.color === "blue")
  const rightColumnStats = statistics.filter((stat) => stat.color === "green")

  return (
    <div className="bg-white dark:bg-zinc-900 rounded-lg p-6 shadow-sm border border-gray-200 dark:border-zinc-800">
      {/* Header */}
      <div className="flex items-center justify-between flex-wrap gap-4 mb-6">
        <h3 className="text-lg font-semibold text-gray-900 dark:text-gray-100">Geo Distribution</h3>
        <button className="p-2 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors">
          <Download className="w-4 h-4 text-gray-500 dark:text-gray-400" />
        </button>
      </div>

      {/* World Map */}
      <div className="mb-6 relative">
        <div className="w-full h-64 rounded-lg overflow-hidden">
          <Chart chartType="GeoChart" width="100%" height="100%" data={countries} options={mapOptions} />
        </div>

        {/* Color scale */}
        <div className="flex items-center justify-start mt-4 space-x-2">
          <span className="text-sm text-gray-600 dark:text-gray-400">60</span>
          <div className="w-32 h-3 bg-gradient-to-r from-green-200 to-green-600 rounded"></div>
          <span className="text-sm text-gray-600 dark:text-gray-400">200</span>
        </div>
      </div>

      {/* Statistics */}
      <div className="grid grid-cols-2 gap-8">
        {/* Left Column */}
        <div className="space-y-4">
          {leftColumnStats.map((item, index) => (
            <div key={index} className="space-y-2">
              <div className="flex justify-between items-center">
                <span className="text-sm font-medium text-gray-700 dark:text-gray-300">{item.region}</span>
                <span className="text-sm font-semibold text-gray-900 dark:text-gray-100">{item.percentage}%</span>
              </div>
              <div className="w-full bg-gray-200 dark:bg-gray-600 rounded-full h-2">
                <div className="h-2 rounded-full bg-blue-500" style={{ width: `${item.percentage}%` }}></div>
              </div>
            </div>
          ))}
        </div>

        {/* Right Column */}
        <div className="space-y-4">
          {rightColumnStats.map((item, index) => (
            <div key={index} className="space-y-2">
              <div className="flex justify-between items-center">
                <span className="text-sm font-medium text-gray-700 dark:text-gray-300">{item.region}</span>
                <span className="text-sm font-semibold text-gray-900 dark:text-gray-100">{item.percentage}%</span>
              </div>
              <div className="w-full bg-gray-200 dark:bg-gray-600 rounded-full h-2">
                <div className="h-2 rounded-full bg-green-500" style={{ width: `${item.percentage}%` }}></div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </div>
  )
}
