"use client"

import { useState } from "react"
import { Button } from "@/Components/UI/Button"
import { Input } from "@/Components/UI/Input"
import { router } from "@inertiajs/react"
import useTranslate from "@/hooks/useTranslate";


export default function Logging({settings}) {
  const [loggingData, setLoggingData] = useState({
    sentry_dns: settings.sentry_dns,
  })

  const t = useTranslate()

  

  const [isSubmitting, setIsSubmitting] = useState(false)

  const handleInputChange = (e) => {
    const { name, value } = e.target
    setLoggingData((prev) => ({
      ...prev,
      [name]: value,
    }))
  }

  const handleSubmit = (e) => {
    e.preventDefault()
    setIsSubmitting(true)

    router.post(route('user.setting.store'), loggingData, {
      onFinish: () => setIsSubmitting(false),
      onError: () => setIsSubmitting(false),
    })

  }

  return (
    <div className="space-y-8">
      {/* Header */}
      <div className="flex items-center justify-between mb-6">
        <div>
          <h3 className="text-lg font-semibold text-gray-900 dark:text-gray-100">{t("System Monitoring")}</h3>
          <p className="text-sm text-gray-500 dark:text-gray-400 mt-1">
            {t("Configure error tracking and monitoring services")}
          </p>
        </div>
        <Button
          type="submit"
          isLoading={isSubmitting}
          onClick={handleSubmit}
          className="bg-gradient-to-r from-primary to-secondary hover:from-primary/90 hover:to-secondary/90 text-white px-6 py-2.5 rounded-lg font-medium shadow-sm transition-all duration-200 flex items-center gap-2"
        >
          {!isSubmitting && (
            <svg className="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
            </svg>
          )}
          {isSubmitting ? t("Saving...") : t("Save Configuration")}
        </Button>
      </div>

      {/* Error Tracking Configuration */}
      <div className="bg-white dark:bg-zinc-800 rounded-xl border border-gray-200 dark:border-zinc-700 p-6">
        <div className="flex items-center gap-3 mb-6">
          <div className="w-12 h-12 bg-gradient-to-br from-red-100 to-orange-100 dark:from-red-900/30 dark:to-orange-900/30 rounded-lg flex items-center justify-center">
            <svg className="w-6 h-6 text-red-600 dark:text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L4.082 16.5c-.77.833.192 2.5 1.732 2.5z" />
            </svg>
          </div>
          <div>
            <h4 className="text-base font-semibold text-gray-900 dark:text-gray-100">{t("Error Tracking & Monitoring")}</h4>
            <p className="text-sm text-gray-500 dark:text-gray-400">{t("Real-time error monitoring and application insights")}</p>
          </div>
        </div>

        <form onSubmit={handleSubmit} className="space-y-6">
          <div>
            <label htmlFor="sentryDns" className="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
              {t("Sentry DSN")}
            </label>
            <Input
              id="sentryDns"
              name="sentry_dns"
              type="text"
              value={loggingData.sentry_dns}
              onChange={handleInputChange}
              className="bg-gray-50 border-gray-200 dark:bg-zinc-900 dark:border-zinc-600 dark:text-gray-100"
              placeholder="https://...@o123456.ingest.sentry.io/..."
            />
            <p className="text-xs text-gray-500 dark:text-gray-400 mt-1">
              {t("Enter your Sentry DSN for comprehensive error tracking and performance monitoring")}
            </p>
          </div>

          <div className="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4">
            <div className="flex items-start gap-3">
              <svg className="w-5 h-5 text-blue-600 dark:text-blue-400 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
              </svg>
              <div>
                <p className="text-sm text-blue-800 dark:text-blue-200">
                  <a href="https://sentry.io" target="_blank" rel="noopener noreferrer" className="font-medium hover:underline">
                    {t("Sentry")}
                  </a>{" "}
                  {t("integration provides real-time error tracking and helps identify and fix issues when site is in production.")}
                </p>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  )
}