"use client"

import { Button } from "@/Components/UI/Button"
import useTranslate from "@/hooks/useTranslate"

const PROFESSIONAL_THEMES = [
  {
    name: "Modern Blue",
    id: "modern_blue",
    preview: "linear-gradient(135deg, #667eea 0%, #764ba2 100%)",
    colors: {
      primary_color: "#667eea",
      secondary_color: "#764ba2", 
      primary_color_text: "#ffffff",
      secondary_color_text: "#ffffff",
      body_text_primary: "#1a202c",
      body_text_secondary: "#718096"
    }
  },
  {
    name: "Success Green",
    id: "success_green", 
    preview: "linear-gradient(135deg, #11998e 0%, #38ef7d 100%)",
    colors: {
      primary_color: "#11998e",
      secondary_color: "#38ef7d",
      primary_color_text: "#ffffff", 
      secondary_color_text: "#ffffff",
      body_text_primary: "#1a202c",
      body_text_secondary: "#718096"
    }
  },
  {
    name: "Royal Purple",
    id: "royal_purple",
    preview: "linear-gradient(135deg, #9f7aea 0%, #667eea 100%)", 
    colors: {
      primary_color: "#9f7aea",
      secondary_color: "#667eea",
      primary_color_text: "#ffffff",
      secondary_color_text: "#ffffff", 
      body_text_primary: "#1a202c",
      body_text_secondary: "#718096"
    }
  },
  {
    name: "Sunset Orange",
    id: "sunset_orange",
    preview: "linear-gradient(135deg, #fdbb2d 0%, #22c1c3 100%)",
    colors: {
      primary_color: "#fdbb2d",
      secondary_color: "#22c1c3",
      primary_color_text: "#1a202c",
      secondary_color_text: "#ffffff",
      body_text_primary: "#1a202c", 
      body_text_secondary: "#718096"
    }
  },
  {
    name: "Professional Dark",
    id: "professional_dark",
    preview: "linear-gradient(135deg, #2d3748 0%, #4a5568 100%)",
    colors: {
      primary_color: "#2d3748",
      secondary_color: "#4a5568",
      primary_color_text: "#ffffff",
      secondary_color_text: "#ffffff",
      body_text_primary: "#2d3748",
      body_text_secondary: "#718096"
    }
  },
  {
    name: "Ocean Breeze",
    id: "ocean_breeze", 
    preview: "linear-gradient(135deg, #74b9ff 0%, #0984e3 100%)",
    colors: {
      primary_color: "#74b9ff",
      secondary_color: "#0984e3",
      primary_color_text: "#ffffff",
      secondary_color_text: "#ffffff",
      body_text_primary: "#1a202c",
      body_text_secondary: "#718096"
    }
  },
  {
    name: "Rose Gold",
    id: "rose_gold",
    preview: "linear-gradient(135deg, #ffecd2 0%, #fcb69f 100%)", 
    colors: {
      primary_color: "#fcb69f",
      secondary_color: "#ffecd2",
      primary_color_text: "#1a202c",
      secondary_color_text: "#1a202c",
      body_text_primary: "#1a202c",
      body_text_secondary: "#718096"
    }
  },
  {
    name: "Forest Green",
    id: "forest_green",
    preview: "linear-gradient(135deg, #134e5e 0%, #71b280 100%)",
    colors: {
      primary_color: "#134e5e", 
      secondary_color: "#71b280",
      primary_color_text: "#ffffff",
      secondary_color_text: "#ffffff",
      body_text_primary: "#1a202c",
      body_text_secondary: "#718096"
    }
  }
]

export default function ThemeColorTemplates({ onTemplateSelect, currentTheme }) {
  const t = useTranslate()
  
  const isCurrentTemplate = (template) => {
    if (!currentTheme) return false
    return currentTheme.primary_color === template.colors.primary_color && 
           currentTheme.secondary_color === template.colors.secondary_color
  }

  return (
    <div className="space-y-4">
      <div className="flex items-center justify-between">
        <h3 className="text-lg font-semibold text-bodyTextPrimary dark:text-neutral-200">
          {t("Professional Theme Templates")}
        </h3>
        <p className="text-sm text-bodyTextSecondary dark:text-neutral-400">
          {t("Choose from our curated professional themes")}
        </p>
      </div>
      
      <div className="grid grid-cols-2 md:grid-cols-4 gap-4">
        {PROFESSIONAL_THEMES.map((theme) => (
          <div
            key={theme.id}
            className={`group relative cursor-pointer rounded-lg border-2 p-3 transition-all duration-200 hover:shadow-lg ${
              isCurrentTemplate(theme)
                ? 'border-blue-500 shadow-md'
                : 'border-gray-200 hover:border-gray-300 dark:border-gray-600 dark:hover:border-gray-500'
            }`}
            onClick={() => onTemplateSelect(theme.colors)}
          >
            {/* Preview Gradient */}
            <div
              className="h-16 w-full rounded-md mb-3 shadow-sm"
              style={{ background: theme.preview }}
            />
            
            {/* Theme Info */}
            <div className="text-center">
              <h4 className="text-sm font-medium text-bodyTextPrimary dark:text-neutral-200 mb-1">
                {t(theme.name)}
              </h4>
              
              {/* Color Dots */}
              <div className="flex justify-center gap-1">
                <div
                  className="w-3 h-3 rounded-full border border-gray-300"
                  style={{ backgroundColor: theme.colors.primary_color }}
                />
                <div
                  className="w-3 h-3 rounded-full border border-gray-300"
                  style={{ backgroundColor: theme.colors.secondary_color }}
                />
              </div>
            </div>
            
            {/* Active Indicator */}
            {isCurrentTemplate(theme) && (
              <div className="absolute -top-1 -right-1 w-6 h-6 bg-blue-500 rounded-full flex items-center justify-center">
                <svg className="w-3 h-3 text-white" fill="currentColor" viewBox="0 0 20 20">
                  <path fillRule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clipRule="evenodd" />
                </svg>
              </div>
            )}
            
            {/* Hover Effect */}
            <div className="absolute inset-0 rounded-lg bg-black opacity-0 group-hover:opacity-5 transition-opacity duration-200" />
          </div>
        ))}
      </div>
      
      {/* Custom Theme Note */}
      <div className="mt-6 p-4 bg-blue-50 dark:bg-blue-900/20 rounded-lg border border-blue-200 dark:border-blue-800">
        <div className="flex items-start space-x-3">
          <svg className="w-5 h-5 text-blue-500 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
            <path fillRule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clipRule="evenodd" />
          </svg>
          <div>
            <h4 className="text-sm font-medium text-blue-800 dark:text-blue-300">
              {t("Custom Colors")}
            </h4>
            <p className="text-sm text-blue-700 dark:text-blue-400 mt-1">
              {t("You can still customize individual colors using the color pickers below after selecting a template.")}
            </p>
          </div>
        </div>
      </div>
    </div>
  )
}

export { PROFESSIONAL_THEMES }