"use client"

import { MoreHorizontal, Edit, Share, Eye, Trash2 } from "lucide-react"
import { Avatar, AvatarFallback, AvatarImage } from "@/Components/UI/Avatar"
import PlatformIcon from "@/Components/UI/PlatformIcon"

export default function PostCardCalendar({ post, onMenuAction, openMenus, onToggleMenu, onDragStart, onDragEnd, className = "" }) {
  return (
    <div
      data-post-card
      className={`relative group cursor-move transform transition-all duration-200 hover:scale-[1.02] active:scale-95 select-none ${className}`}
      draggable
      onDragStart={(e) => {
        try {
          e.dataTransfer.effectAllowed = 'move'
          e.dataTransfer.setData('text/plain', post.id)
          onDragStart && onDragStart(e, post)
        } catch (error) {
          console.warn('Drag start error:', error)
        }
      }}
      onDragEnd={(e) => {
        try {
          onDragEnd && onDragEnd(e, post)
        } catch (error) {
          console.warn('Drag end error:', error)
        }
      }}
      onMouseDown={(e) => {
        // Prevent drag when clicking on menu button
        if (e.target.closest('button')) {
          e.stopPropagation()
        }
      }}
    >
      <div className="bg-gray-200 dark:bg-gray-700 rounded-md p-2 text-xs hover:bg-gray-100 dark:hover:bg-gray-600 transition-colors">
        <div className="flex items-center gap-1 mb-1">
          <div className="relative">
            <Avatar className="h-10 w-10">
              <AvatarImage src={post?.account?.avatar} alt="User Avatar" />
              <AvatarFallback>AV</AvatarFallback>
            </Avatar>
            <div className="absolute -bottom-0.5 -right-0.5 w-5 h-5 rounded-full bg-white dark:bg-zinc-900 flex items-center justify-center border-2 border-white dark:border-gray-900">
              <PlatformIcon slug={post.platform?.slug} size={14} round={true} />
            </div>
          </div>
          <span className="text-gray-600 dark:text-gray-400 text-[10px]">{post.time}</span>

          <div className="ml-auto relative">
            <button
              onClick={(e) => {
                e.preventDefault()
                e.stopPropagation()
                onToggleMenu && onToggleMenu(post.id, e)
              }}
              className="opacity-0 group-hover:opacity-100 p-0.5 hover:bg-gray-200 dark:hover:bg-gray-600 rounded transition-all z-10 relative"
            >
              <MoreHorizontal className="w-3 h-3" />
            </button>

            {openMenus && openMenus[post.id] && (
              <div className="absolute right-0 top-full mt-1 bg-white dark:bg-zinc-900 border border-gray-200 dark:border-zinc-800 rounded-lg shadow-lg z-50 min-w-[120px] py-1">
                <button
                  onClick={(e) => {
                    e.preventDefault()
                    e.stopPropagation()
                    onMenuAction && onMenuAction(post.id, "edit")
                  }}
                  className="w-full text-left px-2 py-1 text-xs hover:bg-gray-50 dark:hover:bg-gray-700 text-gray-700 dark:text-gray-300 flex items-center gap-1"
                >
                  <Edit className="w-3 h-3" />
                  Edit
                </button>
                <button
                  onClick={(e) => {
                    e.preventDefault()
                    e.stopPropagation()
                    onMenuAction && onMenuAction(post.id, "publish")
                  }}
                  className="w-full text-left px-2 py-1 text-xs hover:bg-gray-50 dark:hover:bg-gray-700 text-gray-700 dark:text-gray-300 flex items-center gap-1"
                >
                  <Share className="w-3 h-3" />
                  Publish Now
                </button>
                <button
                  onClick={(e) => {
                    e.preventDefault()
                    e.stopPropagation()
                    onMenuAction && onMenuAction(post.id, "preview")
                  }}
                  className="w-full text-left px-2 py-1 text-xs hover:bg-gray-50 dark:hover:bg-gray-700 text-gray-700 dark:text-gray-300 flex items-center gap-1"
                >
                  <Eye className="w-3 h-3" />
                  Preview
                </button>
                <button
                  onClick={(e) => {
                    e.preventDefault()
                    e.stopPropagation()
                    onMenuAction && onMenuAction(post.id, "share")
                  }}
                  className="w-full text-left px-2 py-1 text-xs hover:bg-gray-50 dark:hover:bg-gray-700 text-gray-700 dark:text-gray-300 flex items-center gap-1"
                >
                  <Share className="w-3 h-3" />
                  Share
                </button>
                <button
                  onClick={(e) => {
                    e.preventDefault()
                    e.stopPropagation()
                    onMenuAction && onMenuAction(post.id, "delete")
                  }}
                  className="w-full text-left px-2 py-1 text-xs hover:bg-gray-50 dark:hover:bg-gray-700 text-red-600 dark:text-red-400 flex items-center gap-1"
                >
                  <Trash2 className="w-3 h-3" />
                  Delete
                </button>
              </div>
            )}
          </div>
        </div>

        {post.media && post.media.length > 0 ? (
          <div className="relative ">
            <img
              src={post.media[0].thumbnail || "/placeholder.svg"}
              alt="Post content"
              className="w-full h-12 object-cover rounded-sm"
            />
            {post.media[0].type === "video" && (
              <div className="absolute inset-0 flex items-center justify-center">
                <div className="w-6 h-6 bg-red-600 rounded-full flex items-center justify-center">
                  <div className="w-0 h-0 border-l-[6px] border-l-white border-y-[3px] border-y-transparent ml-0.5"></div>
                </div>
              </div>
            )}
          </div>
        ) : (
          <p className="text-gray-700 dark:text-gray-300 text-[10px] line-clamp-2">
            {post.content}
          </p>
        )}

      </div>
    </div>
  )
}
