import { Card } from "@/Components/UI/Card"
import { motion } from "framer-motion"

export default function OverviewCard({ title, value, icon: Icon, index = 0 }) {
  return (
    <motion.div
      initial={{ opacity: 0, y: 15 }}
      animate={{ opacity: 1, y: 0 }}
      transition={{ 
        duration: 0.4, 
        delay: index * 0.05,
        ease: "easeOut"
      }}
    >
      <Card className="p-6 bg-white dark:bg-zinc-900 shadow-sm hover:shadow-md border border-gray-100 dark:border-zinc-800 transition-shadow duration-200 group">
        <div className="flex items-center space-x-4">
          <div className="p-4 bg-gradient-to-br from-primary/10 to-secondary/10 rounded-xl group-hover:from-primary/15 group-hover:to-secondary/15 transition-colors duration-200">
            <Icon className="h-7 w-7 text-primary" />
          </div>
          
          <div className="flex-1">
            <p className="lg:text-3xl text-2xl font-bold bg-gradient-to-r from-gray-900 to-gray-700 dark:from-white dark:to-gray-200 bg-clip-text text-transparent">
              {value}
            </p>
            <p className="text-sm font-medium text-gray-600 dark:text-gray-400 mt-1">
              {title}
            </p>
          </div>
        </div>
      </Card>
    </motion.div>
  )
}
