export default function YouTubePreview({ postContent = "", postType = "video", selectedMedia = [] }) {
  // Mock user data - in real app this would come from selected account
  const mockUser = {
    name: "James Clerk",
    username: "@jamesclerk",
    avatar: "/diverse-user-avatars.png",
    verified: false,
  }

  const highlightContent = (text) => {
    const urlRegex = /(https?:\/\/[^\s]+)/g
    const parts = text.split(urlRegex)

    return parts.map((part, index) => {
      if (urlRegex.test(part)) {
        return (
          <span key={index} className="text-blue-600 dark:text-blue-400">
            {part}
          </span>
        )
      }
      return part
    })
  }

  return (
    <div className="bg-white dark:bg-zinc-900 rounded-lg border border-gray-200 dark:border-zinc-800 overflow-hidden min-h-[320px] w-full">
      {/* Video thumbnail placeholder */}
      <div className="bg-gray-900 aspect-video flex items-center justify-center text-white">
        {selectedMedia.length > 0 && selectedMedia[0].type === "video" ? (
          <video
            src={selectedMedia[0].url}
            poster={selectedMedia[0].thumbnail}
            controls
            className="w-full h-full object-cover"
            preload="metadata"
          >
            Your browser does not support the video tag.
          </video>
        ) : selectedMedia.length > 0 && selectedMedia[0].type === "image" ? (
          <img
            src={selectedMedia[0].thumbnail || selectedMedia[0].url}
            alt={selectedMedia[0].alt || "Video thumbnail"}
            className="w-full h-full object-cover"
          />
        ) : (
          <div className="text-center">
            <div className="w-20 h-20 bg-red-600 rounded-full flex items-center justify-center mb-3 mx-auto">
              <div className="w-0 h-0 border-l-[10px] border-l-white border-y-[8px] border-y-transparent ml-1"></div>
            </div>
            <p className="text-sm">No video selected</p>
          </div>
        )}
      </div>

      <div className="p-4 flex-1">
        <h3 className="font-medium text-gray-900 dark:text-white mb-2 break-words">
          {postContent ? highlightContent(postContent) : "Video Title"}
        </h3>

        <div className="flex items-center gap-2 text-sm text-gray-500 dark:text-gray-400 mb-4">
          <span>0 views</span>
          <span>•</span>
          <span>now</span>
        </div>

        <div className="flex items-center gap-3">
          <img
            src={mockUser.avatar || "/placeholder.svg"}
            alt={mockUser.name}
            className="w-10 h-10 rounded-full flex-shrink-0"
          />
          <div>
            <p className="font-medium text-gray-900 dark:text-white text-sm">{mockUser.name}</p>
            <p className="text-xs text-gray-500 dark:text-gray-400">0 subscribers</p>
          </div>
        </div>
      </div>
    </div>
  )
}
