import * as React from "react"
import { Slot } from "@radix-ui/react-slot"
import { cva } from "class-variance-authority"
import { Loader2 } from "lucide-react"

import { cn } from "@/Lib/utils"

const buttonVariants = cva(
  "inline-flex items-center justify-center whitespace-nowrap rounded-md text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50",
  {
    variants: {
      variant: {
        default: "bg-gradient-to-r from-primary to-secondary text-primaryText hover:from-secondary hover:to-primary px-4 py-2 rounded",
        destructive: "bg-destructive text-destructive-foreground hover:bg-destructive/90",
        outline:  "border border-gray-300 text-gray-700 bg-white hover:bg-gray-100 hover:text-gray-900 " +
+         "dark:border-gray-700 dark:text-gray-200 dark:bg-transparent dark:hover:bg-gray-800 dark:hover:text-white",
        secondary: "bg-secondary text-secondary-foreground hover:bg-secondary/80",
        ghost: "text-gray-700 hover:bg-gray-100 hover:text-gray-900 " +
+         "dark:text-gray-200 dark:hover:bg-gray-800 dark:hover:text-white",

        link: "text-primary underline-offset-4 hover:underline",
        white: "bg-white text-gray-700 border border-gray-200 hover:bg-gray-50 hover:text-gray-900"
      },
      size: {
        default: "h-10 px-4 py-2",
        sm: "h-9 rounded-md px-3",
        lg: "h-11 rounded-md px-8",
        icon: "h-10 w-10",
      },
    },
    defaultVariants: {
      variant: "default",
      size: "default",
    },
  },
)

const Button = React.forwardRef(
  ({ className, variant, size, asChild = false, isLoading = false, children, ...props }, ref) => {
    const Comp = asChild ? Slot : "button"
    return (
      <Comp
        className={cn(buttonVariants({ variant, size, className }))}
        ref={ref}
        disabled={isLoading || props.disabled}
        {...props}
      >
        {isLoading && <Loader2 className="mr-2 h-4 w-4 animate-spin" />}
        {children}
      </Comp>
    )
  },
)
Button.displayName = "Button"

export { Button, buttonVariants }