import React from "react";
import { usePage } from "@inertiajs/react";

export default function PostReaction({ reactKey }) {
    const { reactIcon } = usePage().props;

    const iconObj = reactIcon.find((item) => item.key === reactKey);

    if (!iconObj) return null;

    return (
        <div className="w-5 h-5 flex-none items-center justify-center">
            <img src={iconObj.icon} alt={reactKey} className="w-full h-full" />
        </div>
    );
}
