"use client"

import { useState } from "react"
import { LineChart } from "lucide-react"
import AppLayout from "@/Layouts/AppLayout"
import useTranslate from "@/hooks/useTranslate"
import PerformanceSummary from "@/Components/Analytics/PerformanceSummary"
import PostCard from "@/Components/Analytics/PostCard"
import EngagementChart from "@/Components/Analytics/EngagementChart"
import AccountPerformanceChart from "@/Components/Analytics/AccountPerformanceChart"
import AllContent from "@/Components/Analytics/AllContent"
import AudienceByAge from "@/Components/Analytics/AudienceByAge"
import GeoDistribution from "@/Components/Analytics/GeoDistribution"
import StatisticByGender from "@/Components/Analytics/StatisticByGender"
import { route } from "ziggy-js"
import { router , usePage } from "@inertiajs/react"
 


export default function AnalyticsPage({ platforms, AnalyticalData }) {
  const breadcrumbs = [{ label: "Home", href: route("user.home") }, { label: "Analytics" }]
  const t = useTranslate()

  const { props } = usePage();
  const siteLogo = props.site_logo ?? "/logo.png";
  const siteName = props.site_settings?.site_name ?? "MySite"; 


  const [activePlatform, setActivePlatform] = useState(route().params.slug || null)

  const handleTabChange = (platform) => {
    if (platform === "all") {
      router.get(route("user.analytics.index"))
      setActivePlatform(null)
    } else {
      router.get(route("user.analytics.index"), {
        slug: platform
      })
      setActivePlatform(platform)
    }
  }

  return (
    <>
      <AppLayout breadcrumbs={breadcrumbs}>
        <div className="flex-1 p-6 overflow-auto bg-gray-50 dark:bg-black">
          {/* Header */}
          <div className="mb-6">
            <div className="flex items-center gap-3 mb-2">
              <div>
                <LineChart className="h-6 w-6 text-primary" />
              </div>
              <h1 className="text-xl sm:text-2xl dark:text-gray-200 font-bold">
                Analytics
              </h1>
            </div>
            <p className="text-gray-500 dark:text-gray-200">
              Monitor your social media performance and engagement metrics
            </p>
          </div>

          <div className="space-y-6">
            {/* Platform tabs */}
            <div className="overflow-x-auto">
              <div className="inline-flex bg-white dark:bg-zinc-900 rounded-lg p-1 gap-1">
                <button
                  key="all"
                  onClick={() => handleTabChange("all")}
                  className={`rounded-md px-4 py-2 text-sm font-medium transition-colors ${activePlatform === null
                    ? "bg-gradient-to-r from-primary to-secondary text-white shadow-sm"
                    : "text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700"
                    }`}
                >
                  All Platforms
                </button>
                {platforms.map((platform) => (
                  <button
                    key={platform.slug}
                    onClick={() => handleTabChange(platform.slug)}
                    className={`rounded-md px-4 py-2 text-sm font-medium transition-colors ${activePlatform === platform.slug
                      ? "bg-gradient-to-r from-primary to-secondary text-white shadow-sm"
                      : "text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700"
                      }`}
                  >
                    {platform.name}
                  </button>
                ))}
              </div>
            </div>

            <div className="space-y-6">
              {/* Analytics Components */}
              <PerformanceSummary
                data={AnalyticalData.postSummary}
                metrics={AnalyticalData.postSummary.metrics}
              />
              <div className="grid grid-cols-1">
                <PostCard data={AnalyticalData.topPosts} col="3" />
              </div>
              <div className="grid lg:grid-cols-3 grid-cols-1 gap-6">
                <div className="lg:col-span-2 col-span-full">
                  <EngagementChart data={AnalyticalData.engagementAnalytics} />
                </div>
                <div className="lg:col-span-1 col-span-full">
                  <AccountPerformanceChart
                    data={AnalyticalData.accountPerformance}
                    accounts={AnalyticalData.accountPerformance.accounts}
                  />
                </div>
              </div>
              <div className="grid lg:grid-cols-3 md:grid-cols-2 grid-cols-1 gap-6">
                <AudienceByAge data={AnalyticalData.audienceByAge} />
                <GeoDistribution data={AnalyticalData.geoDistribution} />
                <StatisticByGender data={AnalyticalData.statisticByGender} />
              </div>
              <AllContent data={AnalyticalData.allContents} />
            </div>
          </div>
        </div>
      </AppLayout>
    </>

  )
}
