"use client"
import AppLayout from "@/Layouts/AppLayout"
import CampaignWizard from "@/Components/Campaign/CampaignWizard"
import { route } from "ziggy-js"


export default function EditCampaign({ campaign, platforms, accounts, media, post_templates, ai_modules }) {
    const breadcrumbs = [
        { label: "Home", href: "user.home" },
        { label: "Campaign", href: route("user.campaign.index") },
        { label: "Edit" },
    ]    

    return (
        <AppLayout breadcrumbs={breadcrumbs}>
            <div className="flex-1 p-6 overflow-auto bg-gray-50 dark:bg-black">
                {/* Header */}
                <div className="mb-8">
                    <h1 className="text-2xl font-bold mb-2">Edit Campaign</h1>
                    <p className="text-gray-500">Update your campaign details and settings.</p>
                </div>

                <CampaignWizard
                    platforms={platforms}
                    accounts={accounts}
                    media={media}
                    post_templates={post_templates}
                    campaign={campaign}
                    isEdit={true}
                    ai_modules = {ai_modules}
                />
            </div>
        </AppLayout>
    )
}
