<?php
  
namespace App\Enums\Gateway;

use App\Enums\EnumTrait;
use App\Enums\StatusEnum;
use Illuminate\Support\Arr;

enum SMSGatewayEnum :string {

    use EnumTrait;

    case VONAGE            = '101VON';
    case TWILIO            = '102TWI';
    case MESSAGEBIRD       = '103BIRD';
    case INFOBIP           = '104INFO';



    /**
     * Get SMS Gateway Credential
     *
     * @return array
     */
    public static function getGatewayCredential(? string $gateway =  null) : array {


       $gateways =   [
                        self::VONAGE->value => [
                            "name" => t2k(self::VONAGE->name),
                            "credential" => ([
                                'api_key'    => "your-vonage-api-key",
                                'api_secret' => "your-vonage-api-secret",
                                'sender_id'  => "YourBrand"
                            ]),
                            'default' => StatusEnum::true->status()
                        ],

                        self::TWILIO->value => [
                            "name" => t2k(self::TWILIO->name),
                            "credential" => ([
                                'account_sid'  => "your-twilio-account-sid",
                                'auth_token'   => "your-twilio-auth-token",
                                'from_number'  => "+1234567890"
                            ])
                        ],
                        self::MESSAGEBIRD->value => [
                            "name" => t2k(self::MESSAGEBIRD->name),
                            "credential" => ([
                                'access_key' => "your-messagebird-access-key",
                
                            ])
                        ] ,
                
                        self::INFOBIP->value => [
                            "name" => t2k(self::INFOBIP->name),
                            "credential" => ([
                                'sender_id'        => "YourBrand",
                                'infobip_api_key'  => "your-infobip-api-key",
                                'infobip_base_url' => "https://api.infobip.com"
                            ])
                
                        ],
                ];

       return $gateway 
                  ? Arr::get($gateways , $gateway , [])
                  : $gateways ;
      

    }
}