<?php

namespace App\Http\Controllers;

use App\Http\Services\AnalyticsService;
use App\Models\Platform;
use Inertia\Inertia;

class AnalyticsController extends Controller
{
    protected $analyticsService;

    public function __construct(AnalyticsService $analyticsService)
    {
        $this->analyticsService = new AnalyticsService();
    }
    public function index()
    {

        return Inertia::render("Analytics", [
            "platforms" => Platform::all(),
            'AnalyticalData' => $this->analyticsService->getAnalytics(),
        ]);
    }

}
