<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CampaignUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'campaignName' => ['required', 'string', 'max:255'],
            'description' => ['nullable', 'string'],
            'startDate' => ['nullable', 'date'],
            'endDate' => ['nullable', 'date', 'after_or_equal:startDate'],
            'repeat_every' => ['nullable', 'integer', 'min:0'],
            'repeat_end_date' => ['nullable', 'date', 'after_or_equal:startDate'],

            'campaign_id' => ['nullable', 'integer', 'exists:campaigns,id'],
            'accounts' => ['required', 'array', 'min:1'],
            'accounts.*.account_id' => ['required', 'integer', 'exists:social_accounts,id'],
            'accounts.*.platform_id' => ['nullable', 'integer', 'exists:platforms,id'],
            'accounts.*.post_type' => ['nullable', 'string'],

            'content' => ['nullable', 'string'],
            'links' => ['nullable', 'array'],
            'links.*' => ['nullable'],

            'files' => ['nullable', 'array'],
            'files.*.id' => ['nullable', 'integer', 'exists:files,id'],
            'files.*.caption' => ['nullable', 'string', 'max:255'],
            'files.*.alt' => ['nullable', 'string', 'max:255'],
            'files.*.order' => ['nullable', 'integer', 'min:0'],
            'files.*.upload' => ['nullable', 'file'],

            'is_scheduled' => ['nullable', 'in:0,1'],
            'scheduled_time' => ['nullable', 'date'],
            'is_draft' => ['nullable', 'in:0,1'],
        ];
    }

    public function messages(): array
    {
        return [
            'campaignName.required' => 'The campaign name is required.',
            'campaignName.max' => 'The campaign name may not be greater than 255 characters.',
            'endDate.after_or_equal' => 'The end date must be the same or later than the start date.',
            'repeat_every.integer' => 'Repeat interval must be a number.',
            'repeat_end_date.after_or_equal' => 'Repeat end date must be the same or later than the start date.',

            'accounts.required' => 'You must select at least one account.',
            'accounts.*.account_id.required' => 'Each post must be linked to an account.',
            'accounts.*.account_id.exists' => 'One of the selected accounts is invalid.',
            'accounts.*.post_type.in' => 'Invalid post type provided.',

            'files.*.id.exists' => 'One of the attached files does not exist.',
            'files.*.caption.max' => 'File caption may not be longer than 255 characters.',
            'files.*.alt.max' => 'File alt text may not be longer than 255 characters.',
            'files.*.upload.file' => 'Uploaded item must be a valid file.',


            'is_scheduled.in' => 'Scheduled flag must be either 0 or 1.',
            'is_draft.in' => 'Draft flag must be either 0 or 1.',
        ];
    }
}
