<?php

namespace App\Providers;


use App\Enums\StatusEnum;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;
use Inertia\Inertia;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        // Public path is now in the same directory as the Laravel app
        app()->usePublicPath(base_path('public'));
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {


        try {
            if (Schema::hasTable('sessions')) {
                // DB sessions are fine
            } else {
                config(['session.driver' => 'file']);
            }
        } catch (\Exception $e) {
            // If DB not ready, fallback
            config(['session.driver' => 'file']);
        }
        $defaultAvatars = [
            asset('assets/images/default/avatars/avatar1.png'),
            asset('assets/images/default/avatars/avatar2.png'),
            asset('assets/images/default/avatars/avatar3.png'),
            asset('assets/images/default/avatars/avatar4.png'),
            asset('assets/images/default/avatars/avatar4.png'),
            asset('assets/images/default/avatars/avatar5.png'),
            asset('assets/images/default/avatars/avatar6.png'),
            asset('assets/images/default/avatars/avatar7.png'),
            asset('assets/images/default/avatars/avatar8.png'),
            asset('assets/images/default/avatars/avatar9.png'),
            asset('assets/images/default/avatars/avatar10.png'),
        ];

        $reactIcon = [
            ['key' => 'care', 'icon' => asset('assets/images/icons/care.svg')],
            ['key' => 'like', 'icon' => asset('assets/images/icons/like.svg')],
            ['key' => 'love', 'icon' => asset('assets/images/icons/love.svg')],
            ['key' => 'fbcomment', 'icon' => asset('assets/images/icons/fb-comment.svg')],
            ['key' => 'fbshare', 'icon' => asset('assets/images/icons/fb-share.svg')],
        ];

        $loginImage = asset('assets/images/dashboard-analytics.png');


        Inertia::share('defaultAvatars', fn() => $defaultAvatars);
        Inertia::share('reactIcon', fn() => $reactIcon);
        Inertia::share('loginImage', fn() => $loginImage);
        Inertia::share('filePaths', fn() => config('settings.file_path'));
        Inertia::share('statusEnum', fn() => StatusEnum::toArray());

    }

}
