<?php

use App\Enums\LoginKeyEnum;
use App\Enums\StatusEnum;

return [

    "default_template_code" => [
        'name' => "Name",
        'message' => "Message",
        'email' => "Email",
        'phone' => "Phone Number",
        'company_name' => "Company name",
        'logo' => "Site logo"
    ],


    'file_types' => ['3dmf', '3dm', 'avi', 'ai', 'bin', 'bin', 'bmp', 'cab', 'c', 'c++', 'class', 'css', 'csv', 'cdr', 'doc', 'dot', 'docx', 'dwg', 'eps', 'exe', 'gif', 'gz', 'gtar', 'flv', 'fh4', 'fh5', 'fhc', 'help', 'hlp', 'html', 'htm', 'ico', 'imap', 'inf', 'jpe', 'jpeg', 'jpg', 'js', 'java', 'latex', 'log', 'm3u', 'midi', 'mid', 'mov', 'mp3', 'mpeg', 'mpg', 'mp2', 'ogg', 'phtml', 'php', 'pdf', 'pgp', 'png', 'pps', 'ppt', 'ppz', 'pot', 'ps', 'qt', 'qd3d', 'qd3', 'qxd', 'rar', 'ra', 'ram', 'rm', 'rtf', 'spr', 'sprite', 'stream', 'swf', 'svg', 'sgml', 'sgm', 'tar', 'tiff', 'tif', 'tgz', 'tex', 'txt', 'vob', 'wav', 'wrl', 'wrl', 'xla', 'xls', 'xls', 'xlc', 'xml', 'xlsx', 'zip', 'mp4'],

    "role_permissions" => [

        "language" => [
            "view_language",
            "translate_language",
            "create_language",
            "update_language",
            "delete_language",
        ],

        "staff" => [
            "view_staff",
            "create_staff",
            "update_staff",
            "delete_staff",
        ],


        "social_account" => [
            'view_account',
            'create_account',
            'update_account',
            'delete_account',
        ],


        "social_post" => [
            'view_post',
            'create_post',
            'update_post',
            'delete_post',
        ],

        "user" => [
            "view_user",
            "create_user",
            "update_user",
            "delete_user",
        ],


        "role" => [
            "view_role",
            "create_role",
            "update_role",
            "delete_role",
        ],

        "category" => [
            "view_category",
            "create_category",
            "update_category",
            "delete_category"
        ],

        "ai_template" => [
            "view_ai_template",
            "create_ai_template",
            "update_ai_template",
            "delete_ai_template"
        ],

        "content" => [
            "view_content",
            "create_content",
            "update_content",
            "delete_content"
        ],

        "security_settings" => [
            "view_security",
            "update_security",
        ],

        "platform" => [
            "view_platform",
            "update_platform",
        ],


        "gateway" => [
            "view_gateway",
            "update_gateway",
        ],

        "notification_template" => [
            "view_template",
            "update_template"
        ],


        "notification" => [
            "view_notification",
        ],

        "settings" => [
            "view_settings",
            "update_settings"
        ],

        "dashboard" => [
            "view_dashboard"
        ]

    ],

    "file_path" => [
        'profile' => [
            'user' => [
                'path' => 'assets/images/user/profile',
                'size' => '150x150',
            ],
        ],

        'site_logo' => [
            'path' => 'assets/images/backend/site_logo',
            'size' => '150x50',
        ],

        'meta_image' => [
            'path' => 'assets/images/backend/site_logo',
            'size' => '150x50',
        ],

        'user_site_logo' => [
            'path' => 'assets/images/frontend/site_logo',
            'size' => '150x50',
        ],

        'favicon' => [
            'path' => 'assets/images/global/favicon',
            'size' => '25x25',
        ],

        'loader_icon' => [
            'path' => 'assets/images/global/loader',
            'size' => '100x100',
        ],


        'content' => [
            'path' => 'assets/images/global/content',
            'size' => '1024x1024',
        ],

        'content_temp' => [
            'path' => 'assets/images/global/content/temp',
            'size' => '1024x1024',
        ],

        'platform' => [
            'path' => 'assets/images/global/platform',
            'size' => '50x50',
        ],


        'frontend' => [
            'path' => 'assets/images/global/frontend',
        ],

        'gallery' => [
            'path' => 'assets/images/user/gallery',
        ],
        'social' => [
            'template' => [
                'path' => 'assets/images/user/social/template',
            ],
            'post' => [
                'path' => 'assets/images/user/social/post',
            ],
        ],

    ],


    "json_object" => [
        "aws_s3",
        "ftp",
        "pusher_settings",
        "social_login",
        "google_recaptcha",
        "login_with",
        'site_meta_keywords',
        'rand_api_key',
        'mime_types'
    ],


    "login_attribute" => [
        LoginKeyEnum::EMAIL->value,
        LoginKeyEnum::PHONE->value,
        LoginKeyEnum::USERNAME->value
    ],

    "logo_keys" => [
        "site_logo",
        "user_site_logo",
        "favicon",
        "loader_icon",
        "meta_image"
    ],

    "currency_alignment" => [
        "[symbol][amount]" => 0,
        "[amount][symbol]" => 1,
        "[symbol] [amount]" => 2,
        "[amount] [symbol]" => 3
    ],

    "price_format" => [
        "show_full_price" => 0,
        "truncate_price" => 1
    ],

    "date_format" => [
        ['format' => 'd M, Y', 'label' => 'DD MMM, YYYY'],
        ['format' => 'm.d.y', 'label' => 'MM.DD.YY'],
        ['format' => 'Y-m-d', 'label' => 'YYYY-MM-DD'],
        ['format' => 'd-m-Y', 'label' => 'DD-MM-YYYY'],
        ['format' => 'd/m/Y', 'label' => 'DD/MM/YYYY'],
        ['format' => 'Y/m/d', 'label' => 'YYYY/MM/DD'],
    ],

    "time_zone" => [
        'UTC' => 'UTC',
        'Asia/Dhaka' => 'Asia/Dhaka',
        'Asia/Kolkata' => 'Asia/Kolkata',
        'Europe/London' => 'Europe/London',
        'America/New_York' => 'America/New_York',
        'Australia/Sydney' => 'Australia/Sydney',
    ],

    "time_format" => [
        "h:i A",
        "h:i:s A",
        "H:i",
        "H:i:s"
    ],




    // =====================
    // Text AI Module
    // =====================
    'text_ai' => [

        // Generic settings applicable to any provider
        'settings' => [
            'default_tone' => [
                "friendly" => "Friendly",
                "luxury" => "Luxury",
                "relaxed" => "Relaxed",
                "professional" => "Professional",
                "casual" => "Casual",
                "excited" => "Excited",
                "bold" => "Bold",
                "masculine" => "Masculine",
                "dramatic" => "Dramatic",
            ],
            'default_creativity' => [
                "1" => "High",
                "0.5" => "Medium",
                "0" => "Low"
            ],
            'max_result' => 150,
        ],

        'providers' => [
            'openai' => [
                'models' => [
                    "gpt-4-0613" => 'ChatGPT 4 Gpt-4-32k',
                    "gpt-3.5-turbo-16k" => 'ChatGPT 3.5 Turbo-16k',
                    "gpt-3.5-turbo-1106" => 'GPT 3.5 Turbo (Modified)',
                    "gpt-4" => 'ChatGPT 4 (Beta)',
                    "gpt-3.5-turbo" => 'ChatGPT 3.5',
                    "gpt-4-1106-preview" => 'GPT-4 Turbo',
                    "gpt-4-vision-preview" => 'GPT-4 Turbo (vision)',
                ],
            ],

        ],

        'multi_modal' => [

        ],
    ],


    // =====================
    // Image AI Module
    // =====================
    'image_ai' => [
        'settings' => [
            'default_resolution' => [
                '256x256' => '256x256',
                '512x512' => '512x512',
                '1024x1024' => '1024x1024',
                '1792x1024' => '1792x1024',
                '1024x1792' => '1024x1792',
            ],
            'default_quality' => [
                'standard' => 'Standard',
                'hd' => 'HD',
            ],
        ],
        'providers' => [
            'openai' => [
                'models' => [
                    'dall-e-2' => 'DALL-E-2',
                    'dall-e-3' => 'DALL-E-3',
                ],
            ],
            // 'leonardo_ai' => [...], future provider
        ],

        'multi_modal' => [
            // Placeholder for future image + text/video models
        ],
    ],


    // =====================
    // Video AI Module
    // =====================
    'video_ai' => [
        'settings' => [
            'default_aspect_ratio' => [
                '9:16' => '9:16',
                '16:9' => '16:9',
                '1:1' => '1:1',
            ],
            'default_duration' => [
                '5' => '5 sec',
                '10' => '10 sec',
            ],
        ],
        'providers' => [
            'kling_ai' => [
                'models' => [
                    'kling-v1' => 'Kling V1',
                    'kling-v2' => 'Kling V2',

                ],
            ],
        ],

        'multi_modal' => [
            // Placeholder for future video + audio or video + text models
        ],
    ],







    #PLATFORM CONFIGURATION

    "platforms" => [

        'facebook' => [
            'name' => 'Facebook',
            'icon' => 'facebook',
            'credential' => [
                'client_id' => 'your-facebook-app-id',
                'client_secret' => 'your-facebook-app-secret',
                'app_version' => 'v18.0',
                'graph_api_url' => 'https://graph.facebook.com',
                'group_url' => 'https://www.facebook.com/groups',
            ],
            'is_integrated' => StatusEnum::true->status(),
            'is_feature' => StatusEnum::true->status(),
            'view_option' => StatusEnum::true->status()
        ],
        'instagram' => [
            'name' => 'Instagram',
            'icon' => 'instagram',
            'credential' => [
                'client_id' => 'your-instagram-app-id',
                'client_secret' => 'your-instagram-app-secret',
                'app_version' => 'v18.0',
                'graph_api_url' => 'https://graph.facebook.com'
            ],

            'is_integrated' => StatusEnum::true->status(),
            'view_option' => StatusEnum::true->status(),
            'is_feature' => StatusEnum::true->status()

        ],
        "twitter" => [
            'name' => 'Twitter',
            'icon' => 'twitter',
            'credential' => [
                'api_key' => '-',
                'api_secret' => '-',
                'access_token' => '-',
                'access_token_secret' => '-',
                'client_id' => 'your-twitter-client-id',
                'client_secret' => 'your-twitter-client-secret',
                'app_version' => 'v2'
            ],
            'is_integrated' => StatusEnum::true->status(),
            'unofficial' => StatusEnum::false->status(),
            'is_feature' => StatusEnum::true->status()
        ],
        'linkedin' => [
            'name' => 'Linkedin',
            'icon' => 'linkedin',
            'credential' => [
                'client_id' => 'your-linkedin-client-id',
                'client_secret' => 'your-linkedin-client-secret'
            ],
            'is_integrated' => StatusEnum::true->status(),
            'unofficial' => StatusEnum::false->status(),
            'is_feature' => StatusEnum::true->status()
        ],
        'tiktok' => [
            'name' => "Tiktok",
            'icon' => 'tiktok',
            'credential' => [
                'client_key' => 'your-tiktok-client-key',
                'client_secret' => 'your-tiktok-client-secret',
                'app_version' => 'v1.3',
            ],
            'is_integrated' => StatusEnum::true->status(),
            'view_option' => StatusEnum::true->status(),
            'is_feature' => StatusEnum::true->status()

        ],
        'youtube' => [
            'name' => "Youtube",
            'icon' => 'youtube',
            'credential' => [
                'client_id' => 'your-youtube-client-id',
                'client_secret' => 'your-youtube-client-secret',
                'app_version' => 'v3',
            ],
            'is_integrated' => StatusEnum::true->status(),
            'view_option' => StatusEnum::true->status(),
            'is_feature' => StatusEnum::true->status()

        ],
        'threads' => [
            'name' => "Threads",
            'icon' => 'threads',
            'credential' => [
                'client_id' => 'your-threads-client-id',
                'client_secret' => 'your-threads-client-secret',
                'app_version' => 'v1.0',
            ],
            'is_integrated' => StatusEnum::true->status(),
            'view_option' => StatusEnum::true->status(),
            'is_feature' => StatusEnum::true->status()

        ]

    ],

    "platforms_connetion_field" => [

        "facebook" => [
            "access_token"
        ],
        "instagram" => [
            "username",
            "password"
        ],
        "twitter" => [
            'consumer_key',
            'consumer_secret',
            'access_token',
            'token_secret',
            'bearer_token'
        ],
        "tiktok" => [
            'client_key',
            'client_secret',
            'access_token',
            'refresh_token'
        ],
        "youtube" => [
            'client_id',
            'client_secret',
            'access_token',
            'refresh_token'
        ]
    ]

];
