<?php

use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::disableForeignKeyConstraints();

        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('username')->nullable();
            $table->string('email')->unique();
            $table->string('phone')->unique()->nullable();
            $table->string('phone_code')->unique()->nullable();
            $table->string('country_code')->unique()->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->enum('owner', StatusEnum::toArray())->default(StatusEnum::false->status())->comment('Owner : 1 , User :0');
            $table->enum('status', StatusEnum::toArray())->default(StatusEnum::true->status())->comment('Active : 1 , Inactive :0');
            $table->unsignedBigInteger('role_id')->index()->nullable()->constrained(table: 'roles');
            $table->unsignedBigInteger('current_workspace_id')->nullable();
            $table->timestamp('last_login')->nullable();
            $table->string('google2fa_secret')->nullable();
            $table->boolean('two_factor_enabled')->default(false);
            $table->timestamp("two_factor_confirmed_at")->nullable();
            $table->json('recovery_codes')->nullable();
            $table->rememberToken();
            $table->timestamps();
        });
        Schema::enableForeignKeyConstraints();

        Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->string('email')->primary();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::disableForeignKeyConstraints();

        Schema::dropIfExists('users');
        Schema::dropIfExists('password_reset_tokens');
        Schema::dropIfExists('sessions');

        Schema::enableForeignKeyConstraints();

    }
};
