<?php

use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('workspaces', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->string('name');
            $table->string('email')->nullable();
            $table->enum('status', StatusEnum::toArray())->default(StatusEnum::false->status())->comment('Active :1 ; Inactive :0');
            $table->enum('is_default', StatusEnum::toArray())->default(StatusEnum::false->status())->comment('True :1 ; False :0');
            $table->enum('is_current', StatusEnum::toArray())->default(StatusEnum::false->status())->comment('True :1 ; False :0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Schema::dropIfExists('workspaces');
        \DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::dropIfExists('social_accounts');
        Schema::dropIfExists('workspaces');
        \DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
};
