<?php

use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('platforms', function (Blueprint $table) {
            $table->id();
            $table->string('uid', 100)->unique()->nullable();
            $table->string("name", 155);
            $table->string("slug", 155)->unique();
            $table->string("url", 255)->nullable();
            $table->string("icon", 255)->nullable();
            $table->json("configuration")->nullable();

            // Flags
            $table->enum('status', array_values(StatusEnum::toArray()))
                ->default(StatusEnum::true->status())
                ->index()
                ->comment('Active: 1, Inactive: 0');

            $table->enum('is_feature', array_values(StatusEnum::toArray()))
                ->default(StatusEnum::false->status())
                ->comment('Is this platform available as a feature');

            $table->enum('is_integrated', array_values(StatusEnum::toArray()))
                ->default(StatusEnum::false->status())
                ->comment('Integration completed?');

            $table->enum('view_option', array_values(StatusEnum::toArray()))
                ->default(StatusEnum::false->status())
                ->comment('Should show special options in UI');

            $table->enum('unofficial', array_values(StatusEnum::toArray()))
                ->default(StatusEnum::false->status())
                ->comment('Unofficial API integration?');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::disableForeignKeyConstraints();
        Schema::dropIfExists('platforms');
        Schema::enableForeignKeyConstraints();
    }
};
