<?php

namespace Database\Seeders;

use App\Models\PostMetric;
use App\Models\SocialPost;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PopulateMetricSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $posts = SocialPost::all();

        foreach ($posts as $post) {
            PostMetric::firstOrCreate(
                ['post_id' => $post->id],
                [
                    'likes' => rand(10, 5000),
                    'comments' => rand(0, 1000),
                    'shares' => rand(0, 800),
                    'impressions' => rand(1000, 50000),
                    'reactions' => rand(1000, 50000),
                ]
            );
        }
    }
}
