import PlatformIcon from "@/Components/UI/PlatformIcon"
import { Avatar, AvatarFallback, AvatarImage } from "@/Components/UI/Avatar"
import useTranslate from "@/hooks/useTranslate";

const SocialAccounts = ({ data = [] }) => {
    const accounts = data ?? []
    const t = useTranslate()

    return (
        <div className="bg-white dark:bg-zinc-900 rounded-lg shadow-sm border border-gray-200 dark:border-zinc-800 flex flex-col">
            <div className="p-6 pb-0">
                <h3 className="text-lg font-semibold text-gray-900 dark:text-white">
                    {t("Social Accounts")}
                </h3>
                <p className="text-sm text-gray-600 dark:text-gray-400 mt-1">
                    {t("Manage and monitor your connected social accounts")}
                </p>
            </div>

            {accounts.length === 0 ? (
                <div className="flex-1 flex items-center justify-center p-6 h-[28rem]">
                    <p className="text-gray-500 dark:text-neutral-400 text-sm">
                        {t("No accounts found, your connected accounts will appear here")}
                    </p>
                </div>
            ) : (
                <div className="p-6 pt-4 h-[28rem] overflow-y-auto scrollbar-thin scrollbar-thumb-gray-300 dark:scrollbar-thumb-zinc-700 scrollbar-track-transparent">
                    <div className="space-y-4">
                        {accounts.map((account, index) => (
                        <div key={account.id || index} className="flex items-center gap-4 justify-between">
                            <div className="flex items-center space-x-3">
                                <div className="relative">
                                    <Avatar className="h-8 w-8 lg:h-10 lg:w-10">
                                        <AvatarImage src={account?.avatar} alt={t("User Avatar")} />
                                        <AvatarFallback>AV</AvatarFallback>
                                    </Avatar>
                                    <div className="absolute -bottom-0.5 -right-0.5 w-5 h-5 rounded-full bg-white dark:bg-zinc-900 flex items-center justify-center border-2 border-white dark:border-zinc-900">
                                        <PlatformIcon slug={account?.platform?.slug} size={14} round={true} />
                                    </div>
                                </div>
                                <div>
                                    <p className="font-medium text-sm lg:text-base text-gray-900 dark:text-neutral-200 truncate max-w-[60px] lg:max-w-[150px]">
                                        {account.label || account.name}
                                    </p>
                                    {account.label && account.name && account.label !== account.name && (
                                        <p className="text-xs text-gray-500 dark:text-gray-400 truncate max-w-[80px] lg:max-w-[160px]">
                                            {account.name}
                                        </p>
                                    )}
                                </div>
                            </div>

                            <div className="flex-shrink-0">
                                {account.is_connected === "1" ? (
                                    <span className="inline-block px-3 py-1.5 bg-gradient-to-r from-primary to-secondary hover:from-secondary hover:to-primary text-white text-xs font-medium rounded-full">
                                        {t("Connected")}
                                    </span>
                                ) : (
                                    <span className="inline-block px-3 py-1.5 bg-gray-300 dark:bg-zinc-700 text-gray-700 dark:text-neutral-200 text-xs font-medium rounded-full">
                                        {t("Disconnected")}
                                    </span>
                                )}
                            </div>
                        </div>
                        ))}
                    </div>
                </div>
            )}
        </div>
    )
}

export default SocialAccounts
