"use client"

import PostCardGrid from "@/Components/Calendar/PostCardGrid"
import PostCardList from "@/Components/Calendar/PostCardList"
import PostCardCalendar from "@/Components/Calendar/PostCardCalendar"

export default function PostCard({
  post,
  viewMode = "list",
  onMenuAction,
  openMenus,
  onToggleMenu,
  onDragStart,
  className = "",
}) {
  const baseProps = {
    post,
    onMenuAction,
    openMenus,
    onToggleMenu,
    onDragStart,
    className,
  }

  switch (viewMode) {
    case "grid":
      return <PostCardGrid {...baseProps} />
    case "calendar":
      return <PostCardCalendar {...baseProps} />
    case "list":
    default:
      return <PostCardList {...baseProps} />
  }
}
