"use client"

import { Input } from "@/Components/UI/Input"
import { Textarea } from "@/Components/UI/Textarea"

const StepOne = ({ formData, onInputChange }) => {
  return (
    <div className="space-y-8">
      {/* Header */}
      <div className="text-center">
        <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-2">
          Campaign Details
        </h2>
        <p className="text-gray-600 dark:text-gray-400">
          Let's start by defining the basic information for your campaign
        </p>
      </div>

      {/* Form Fields */}
      <div className="max-w-2xl mx-auto space-y-6">
        {/* Campaign Name */}
        <div className="space-y-2">
          <label className="block text-sm font-medium text-gray-700 dark:text-gray-300">
            Campaign Name <span className="text-red-500">*</span>
          </label>
          <Input
            placeholder="e.g., Summer Product Launch 2025"
            value={formData.campaignName}
            onChange={(e) => onInputChange("campaignName", e.target.value)}
            className="w-full bg-white dark:bg-zinc-800 border-gray-300 dark:border-zinc-600 focus:ring-primary focus:border-primary dark:text-white"
          />
        </div>

        {/* Date Range */}
        <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
          <div className="space-y-2">
            <label className="block text-sm font-medium text-gray-700 dark:text-gray-300">
              Start Date <span className="text-red-500">*</span>
            </label>
            <Input
              type="datetime-local"
              value={formData.startDate}
              onChange={(e) => onInputChange("startDate", e.target.value)}
              className="w-full bg-white dark:bg-zinc-800 border-gray-300 dark:border-zinc-600 focus:ring-primary focus:border-primary dark:text-white"
            />
          </div>

          <div className="space-y-2">
            <label className="block text-sm font-medium text-gray-700 dark:text-gray-300">
              End Date <span className="text-red-500">*</span>
            </label>
            <Input
              type="datetime-local"
              value={formData.endDate}
              onChange={(e) => onInputChange("endDate", e.target.value)}
              className="w-full bg-white dark:bg-zinc-800 border-gray-300 dark:border-zinc-600 focus:ring-primary focus:border-primary dark:text-white"
            />
          </div>
        </div>

        {/* Description */}
        <div className="space-y-2">
          <label className="block text-sm font-medium text-gray-700 dark:text-gray-300">
            Campaign Description
          </label>
          <Textarea
            placeholder="Describe your campaign goals, target audience, and key messaging..."
            value={formData.description}
            onChange={(e) => onInputChange("description", e.target.value)}
            className="w-full bg-white dark:bg-zinc-800 border-gray-300 dark:border-zinc-600 focus:ring-primary focus:border-primary dark:text-white resize-none"
            rows={4}
          />
          <p className="text-xs text-gray-500 dark:text-gray-400">
            Optional: Add context to help organize your campaign content
          </p>
        </div>
      </div>
    </div>
  )
}

export default StepOne
