import { MoreHorizontal } from "lucide-react"
import { Button } from "@/Components/UI/Button"
import { DropdownMenu, DropdownMenuContent, DropdownMenuItem, DropdownMenuTrigger } from "@/Components/UI/DropdownMenu"
import { Avatar, AvatarFallback, AvatarImage } from "@/Components/UI/Avatar"
import PlatformIcon from "@/Components/UI/PlatformIcon"

const PostCard = ({ post }) => {



    return (
        <div className="bg-white dark:bg-zinc-900 rounded-lg border-2 border-cyan-400 p-6">
            {/* Post Header */}
            <div className="flex items-center justify-between mb-4">
                <div className="flex items-center space-x-3">
                    <div className="relative">
                        <Avatar className="h-10 w-10">
                            <AvatarImage src={post?.account?.avatar} alt="User Avatar" />
                            <AvatarFallback>AV</AvatarFallback>
                        </Avatar>
                        <div className="absolute -bottom-0.5 -right-0.5 w-5 h-5 rounded-full bg-white dark:bg-zinc-900 flex items-center justify-center border-2 border-white dark:border-gray-900">
                            <PlatformIcon slug={post.platform?.slug} size={14} round={true} />
                        </div>
                    </div>
                    <div>
                        <h3 className="font-semibold text-gray-900 dark:text-white">{post?.author}</h3>
                        <p className="text-xs text-gray-500 dark:text-gray-400">
                            {new Date(post.date).toLocaleDateString(undefined, {
                                weekday: 'short',
                                year: 'numeric',
                                month: 'short',
                                day: 'numeric',
                            })}
                        </p>
                    </div>
                </div>

                
            </div>

            {/* Post Content */}
            <div className="mb-4">
                <p className="text-gray-900 dark:text-white leading-relaxed">
                    {post?.content ||
                        "Hey there! I'm excited to share with you some incredible tools that you absolutely need to get familiar with. These tools are not just handy per..."}
                </p>
            </div>

            {post.media && post.media.length > 0 && (
                <div className="mx-4 mt-3 rounded-lg overflow-hidden flex gap-1">
                    {post.media.slice(0, 2).map((item) =>
                        item.isVideo ? (
                            <video
                                key={item.id}
                                src={item.thumbnail || "/placeholder.mp4"}
                                className="w-1/2 aspect-video object-cover rounded"
                                muted
                                playsInline
                            />
                        ) : (
                            <img
                                key={item.id}
                                src={item.url || "/placeholder.svg"}
                                alt={item.alt || "Post content"}
                                className="w-1/2 aspect-video object-cover rounded"
                            />
                        )
                    )}

                    {post.media.length > 2 && (
                        <div className="w-1/2 aspect-video bg-gray-200 dark:bg-gray-800 rounded flex items-center justify-center text-gray-700 dark:text-gray-300 font-semibold text-lg">
                            +{post.media.length - 2}
                        </div>
                    )}
                </div>
            )}
        </div>
    )
}

export default PostCard
