const MediaCard = ({ item }) => (
    <Card className="overflow-hidden hover:shadow-md transition-shadow">
        <CardContent className="p-0">
            <div className="relative">
                <img src={item.thumbnail || "/placeholder.svg"} alt={item.title} className="w-full h-24 object-cover" />
                {item.isVideo && (
                    <div className="absolute inset-0 flex items-center justify-center">
                        <div className="bg-black/50 rounded-full p-3">
                            <Play className="h-6 w-6 text-white fill-white" />
                        </div>
                    </div>
                )}
                <div className="absolute top-2 right-2">
                    <DropdownMenu>
                        <DropdownMenuTrigger asChild>
                            <Button
                                variant="ghost"
                                size="sm"
                                className="h-8 w-8 p-0 bg-black/20 hover:bg-black/40 text-white rounded-full"
                            >
                                <MoreVertical className="h-4 w-4" />
                            </Button>
                        </DropdownMenuTrigger>
                        <DropdownMenuContent align="end" className="w-32">
                            <DropdownMenuItem className="flex items-center gap-2" onClick={() => openPreview(item)}>
                                <Eye className="h-4 w-4" />
                                Preview
                            </DropdownMenuItem >
                            <DropdownMenuItem className="flex items-center gap-2" onClick={() => handleDownload(item)}>
                                <Download className="h-4 w-4" />
                                Download
                            </DropdownMenuItem>
                            <DropdownMenuItem className="flex items-center gap-2 text-red-600" onClick={() => handleDeleteClick(item)} >
                                <Trash2 className="h-4 w-4" />
                                Delete
                            </DropdownMenuItem>
                        </DropdownMenuContent>
                    </DropdownMenu>
                </div>
            </div>
            <div className="p-4">
                <h3 className="font-medium text-sm mb-1 truncate">{item.title}</h3>
                <p className="text-xs text-muted-foreground">{item.type}</p>
            </div>
        </CardContent>
    </Card>
)