"use client"

import { useState } from "react"
import { Input } from "@/Components/UI/Input"
import { Button } from "@/Components/UI/Button"
import useTranslate from "@/hooks/useTranslate";
import { router, usePage } from "@inertiajs/react"

export default function AwsS3() {
  const { props } = usePage();
  const site_settings = props?.site_settings
  const [isSubmitting, setIsSubmitting] = useState(false)
  const [isS3Enabled, setIsS3Enabled] = useState(
    site_settings?.s3_storage === 1 || site_settings?.s3_storage === "1"
  )
  const [formData, setFormData] = useState({
    s3_key: site_settings?.s3_key,
    s3_secret: site_settings?.s3_secret,
    s3_region: site_settings?.s3_region,
    s3_bucket: site_settings?.s3_bucket,
  })


  const t = useTranslate()

  const handleInputChange = (field, value) => {
    setFormData((prev) => ({
      ...prev,
      [field]: value,
    }))
  }

  const handleSubmit = (e) => {
    e.preventDefault()
    setIsSubmitting(true)

    router.post(route('user.setting.store'), {
      aws_storage: isS3Enabled ? "1" : "0",
      ...formData,
    }, {
      onFinish: () => setIsSubmitting(false),
      onError: () => setIsSubmitting(false),
    })
  }



  return (
    <div className="space-y-8">
      {/* S3 Storage Toggle */}
      <div className="flex items-center space-x-3">
        <label className="text-sm font-medium text-bodyTextPrimary dark:text-gray-200">{t("S3 Storage")}</label>
        <button
          type="button"
          onClick={() => setIsS3Enabled(!isS3Enabled)}
          className={`relative inline-flex h-6 w-11 items-center rounded-full transition-colors focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:ring-offset-2 ${isS3Enabled ? "bg-cyan-400" : "bg-gray-200"
            }`}
        >
          <span
            className={`inline-block h-4 w-4 transform rounded-full bg-white transition-transform ${isS3Enabled ? "translate-x-6" : "translate-x-1"
              }`}
          />
        </button>
      </div>

      {/* Form Fields */}
      <form onSubmit={handleSubmit} className="space-y-6">
        <div className="grid lg:grid-cols-2 grid-cols-1 lg:gap-6 gap-4">
          {/* Left Column */}
          <div className="space-y-6">
            <div>
              <label className="block text-sm font-medium text-bodyTextPrimary dark:text-gray-200 mb-2">{t("S3 Key")}</label>
              <Input
                type="text"
                placeholder="Enter your AWS S3 access key"
                value={formData.s3_key}
                onChange={(e) => handleInputChange("s3_key", e.target.value)}
                className="bg-gray-50 border-gray-200"
              />
            </div>

            <div>
              <label className="block text-sm font-medium text-bodyTextPrimary dark:text-gray-200 mb-2">{t("S3 Region")}</label>
              <Input
                type="text"
                placeholder="Enter your AWS S3 region (e.g., us-east-1)"
                value={formData.s3_region}
                onChange={(e) => handleInputChange("s3_region", e.target.value)}
                className="bg-gray-50 border-gray-200"
              />
            </div>
          </div>

          {/* Right Column */}
          <div className="space-y-6">
            <div>
              <label className="block text-sm font-medium text-bodyTextPrimary dark:text-gray-200 mb-2">{t("S3 Secret")}</label>
              <Input
                type="password"
                placeholder="Enter your AWS S3 secret key"
                value={formData.s3_secret}
                onChange={(e) => handleInputChange("s3_secret", e.target.value)}
                className="bg-gray-50 border-gray-200"
              />
            </div>

            <div>
              <label className="block text-sm font-medium text-bodyTextPrimary dark:text-gray-200 mb-2">{t("S3 Bucket")}</label>
              <Input
                type="text"
                placeholder="Enter your S3 bucket name"
                value={formData.s3_bucket}
                onChange={(e) => handleInputChange("s3_bucket", e.target.value)}
                className="bg-gray-50 border-gray-200"
              />
            </div>
          </div>
        </div>

        {/* Submit Button */}
        <div className="pt-4">
          <Button 
          isLoading = {isSubmitting}
          type="submit" 
          className="bg-cyan-400 hover:bg-cyan-500 text-white px-8 py-2.5 rounded-md font-medium"
          >
            { isSubmitting ? t("Submitting...")  : t("Submit")}
          </Button>
        </div>
      </form>
    </div>
  )
}
