import { Link } from "@inertiajs/react";

const NavLink = ({ href, active, children, className = "" }) => {
  return (
    <Link
      href={href}
      className={`w-12 h-10 rounded-lg flex items-center justify-center transition-colors ${
        active
          ? "bg-gradient-to-r from-primary to-secondary text-white"
          : "text-gray-500 hover:bg-gray-100 hover:dark:bg-zinc-700"
      } ${className}`}
    >
      {children}
    </Link>
  );
};

export { NavLink };
