import React, { useState } from "react";
import { cn } from "@/Lib/utils";

const SiteLogo = React.forwardRef(({ src, siteName = "PostUno", size = 48, className = "", variant = "gradient", showText = true, ...props }, ref) => {
  const [imageError, setImageError] = useState(false);
  
  const initials = siteName
    .split(" ")
    .map(word => word[0])
    .join("")
    .toUpperCase()
    .slice(0, 2);

  const variants = {
    gradient: "bg-gradient-to-br from-blue-500 via-purple-500 to-pink-500",
    solid: "bg-blue-600",
    dark: "bg-gray-800 dark:bg-gray-700",
    branded: "bg-gradient-to-br from-indigo-500 to-purple-600"
  };

  // If src exists and no error, show image
  if (src && !imageError) {
    return (
      <img
        ref={ref}
        src={src}
        alt={siteName}
        width={size}
        height={size}
        className={cn("rounded-xl object-cover shadow-sm border border-gray-200 dark:border-zinc-800", className)}
        style={{ width: size, height: size }}
        onError={() => setImageError(true)}
        {...props}
      />
    );
  }

  // Fallback to professional icon/initials
  return (
    <div
      ref={ref}
      className={cn(
        "flex items-center justify-center rounded-xl text-white font-bold shadow-sm border border-gray-200 dark:border-gray-600",
        variants[variant],
        className
      )}
      style={{ width: size, height: size }}
      {...props}
    >
      {size >= 24 ? (
        // Always show just icon for larger sizes when image is not found
        <svg 
          className={`${size >= 48 ? 'w-8 h-8' : size >= 32 ? 'w-6 h-6' : 'w-5 h-5'}`}
          fill="none" 
          stroke="currentColor" 
          viewBox="0 0 24 24"
        >
          <path 
            strokeLinecap="round" 
            strokeLinejoin="round" 
            strokeWidth={2} 
            d="M13 10V3L4 14h7v7l9-11h-7z" 
          />
        </svg>
      ) : (
        // Just initials for smaller sizes
        <span className={`text-xs font-bold`}>
          {initials}
        </span>
      )}
    </div>
  );
});

SiteLogo.displayName = "SiteLogo";
export default SiteLogo;
