import { LanguageProvider } from "@/Contexts/LanguageContext";
import useTranslate from "@/hooks/useTranslate";
import { ThemeProvider } from "@/Contexts/ThemeContext";
import FlashMessages from "@/Components/FlashMessages";
import { usePage } from '@inertiajs/react';

export default function AuthLayout({ children }) {
  const t = useTranslate();
  const props = usePage().props;
  const siteName = props.site_settings?.site_name || 'PostUno';
  
  return (
    <ThemeProvider>
      <LanguageProvider>
        <FlashMessages />
        <div className="h-screen flex flex-col lg:flex-row auth-mobile-compact auth-xs-compact auth-landscape overflow-hidden">
          {/* Left side - Hide on mobile, show on lg and up */}
          <div className="hidden lg:flex relative flex-1 bg-gradient-to-br from-blue-300 to-cyan-200 flex-col max-h-screen">
            <div className="flex-1 flex items-center justify-center p-4 lg:p-6 xl:p-8 2xl:p-12 overflow-hidden">
              <img
                src={props.loginImage}
                alt="Social media engagement statistics"
                className="max-w-full max-h-full object-contain"
              />
            </div>
            <div className="flex-none w-full bg-gray-900 text-white p-4 lg:p-6 xl:p-8 2xl:p-12">
              <h3 className="text-lg lg:text-xl xl:text-2xl 2xl:text-3xl font-bold mb-3 lg:mb-4">{t("Enhance your social media strategy with smart automation.")}</h3>
              <p className="text-gray-300 text-sm lg:text-base xl:text-lg">
                {t("A complete platform to simplify social media management for small and mid-sized businesses.")}
              </p>
            </div>
          </div>

          {/* Right side - Full width on mobile with optimized spacing */}
          <div className="flex-1 flex flex-col justify-center items-center px-4 py-6 sm:px-6 sm:py-8 lg:px-8 lg:py-10 xl:px-12 xl:py-12 2xl:px-16 2xl:py-16 bg-white dark:bg-zinc-900 relative h-screen lg:max-h-screen auth-safe-area auth-landscape-content overflow-hidden">
            {/* Mobile header - Show only on mobile with reduced spacing */}
            <div className="lg:hidden w-full text-center mb-4 sm:mb-6">
              <h2 className="text-xl sm:text-2xl font-bold bg-gradient-to-r from-primary to-secondary bg-clip-text text-transparent mb-2">{siteName}</h2>
              <p className="text-sm text-gray-600 dark:text-gray-400">
                {t("Social Media Management Platform")}
              </p>
            </div>

            {/* Main content container with optimized sizing for all screens */}
            <div className="w-full max-w-sm sm:max-w-md lg:max-w-lg xl:max-w-xl 2xl:max-w-2xl bg-white/80 backdrop-blur-xl px-4 py-6 sm:px-6 sm:py-8 lg:px-8 lg:py-10 xl:px-10 xl:py-12 2xl:px-12 2xl:py-14 rounded-lg sm:rounded-xl lg:rounded-2xl shadow-lg lg:shadow-xl xl:shadow-2xl shadow-black/10 dark:shadow-black/30 border border-white/20 dark:border-zinc-700/50 dark:bg-zinc-900/80 dark:text-neutral-200 flex-shrink-0 max-h-[calc(100vh-2rem)] overflow-y-auto">
              {children}
            </div>

            {/* Footer with responsive positioning */}
            <div className="mt-4 sm:mt-6 lg:mt-8 xl:mt-10 2xl:absolute 2xl:bottom-6 2xl:left-1/2 2xl:transform 2xl:-translate-x-1/2 text-xs sm:text-sm text-gray-500 text-center flex-shrink-0">
              {t("© 2025")} {siteName}. {t("All rights reserved.")}
            </div>
          </div>
        </div>
      </LanguageProvider>
    </ThemeProvider>
  )
}
