"use client"

import { usePage } from "@inertiajs/react"
import { useState } from "react"
import { Input } from "@/Components/UI/Input"
import { Button } from "@/Components/UI/Button"
import AuthLayout from "@/Layouts/AuthLayout"
import { ArrowLeft } from "lucide-react"
import { router } from "@inertiajs/react"
import useTranslate from "@/hooks/useTranslate";

export default function ResetPassword() {
  const { errors } = usePage().props
  const [email, setEmail] = useState("")
  const [message, setMessage] = useState("")
  const [isSubmitting, setIsSubmitting] = useState(false)

  const t = useTranslate();

  const handleSubmit = (e) => {
    e.preventDefault()
    setIsSubmitting(true)
    const url = route("auth.password.email")
    router.post(url, { email: email } , {
      onFinish: () => setIsSubmitting(false),
      onError: () => setIsSubmitting(false),
    })
  }

  const handleBack = () => {
    window.history.back()
  }

  return (
    <AuthLayout>
      <div className="relative">
        {" "}
        {/* Added relative positioning for the arrow */}
        <Button
          variant="ghost"
          size="icon"
          onClick={handleBack}
          className="absolute -top-2 -left-2 text-gray-600 dark:text-gray-200 hover:bg-gray-100"
          aria-label="Go back"
        >
          <ArrowLeft className="h-6 w-6" />
        </Button>
        <h1 className="text-2xl font-bold mb-8 text-center">{t("Reset Your Password")}</h1>
        <p className="text-center text-gray-600 dark:text-gray-200 mb-6">
          {t("Input your email address account to receive a verification code.")}
        </p>
        <form onSubmit={handleSubmit}>
          <div className="mb-6">
            <label htmlFor="email" className="block mb-2 text-sm font-semibold text-gray-700 dark:text-gray-200">
             {t("Email")} 
            </label>
            <Input
              type="email"
              id="email"
              name="email"
              value={email}
              onChange={(e) => setEmail(e.target.value)}
              placeholder={t("Enter your email address")}
              required
              className="w-full px-4 py-3 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-primary dark:bg-zinc-800 dark:border-zinc-600 dark:text-white"
            />
            {errors.email && (
              <div className="text-red-500 text-sm mt-1">{errors.email}</div>
            )}
          </div>
          <Button
            type="submit"
            isLoading={isSubmitting}
            className="w-full bg-gradient-to-r from-primary to-secondary text-white hover:from-secondary hover:to-primary shadow-md hover:shadow-lg transition-all duration-200"
          >
            {isSubmitting ? t("Sending...") : t("Send Reset Link")}
          </Button>
        </form>
        {message && <p className="mt-4 text-center text-sm text-green-600">{message}</p>}
      </div>
    </AuthLayout>
  )
}
