"use client"

import { useState } from "react"
import { router } from "@inertiajs/react"
import { Button } from "../../Components/UI/Button"
import { Card, CardContent } from "../../Components/UI/Card"
import { 
  Rocket, 
  CheckCircle2, 
  ArrowRight,
  Shield,
  Zap,
  Database,
  Settings2
} from "lucide-react"
import { motion } from "framer-motion"

export default function Welcome({ appName = "Postuno" }) {
  const [isLoading, setIsLoading] = useState(false)

  const handleStart = () => {
    setIsLoading(true)
    router.visit("/install/requirement-verification?verify_token=" + btoa("requirements"))
  }

  const features = [
    { icon: Shield, title: "Secure Installation", desc: "SSL encrypted setup process" },
    { icon: Zap, title: "Quick Setup", desc: "Get started in under 5 minutes" },
    { icon: Database, title: "Database Configuration", desc: "Easy database connection setup" },
    { icon: Settings2, title: "Auto Configuration", desc: "Automatic environment setup" }
  ]

  return (
    <div className="min-h-screen bg-gradient-to-br from-blue-50 via-white to-purple-50 dark:from-gray-900 dark:via-gray-800 dark:to-gray-900">
      <div className="container mx-auto px-4 py-12">
        <div className="max-w-4xl mx-auto">
          {/* Header */}
          <motion.div 
            initial={{ opacity: 0, y: -20 }}
            animate={{ opacity: 1, y: 0 }}
            className="text-center mb-12"
          >
            <div className="inline-flex items-center justify-center w-20 h-20 rounded-full bg-gradient-to-r from-blue-500 to-purple-600 mb-6">
              <Rocket className="w-10 h-10 text-white" />
            </div>
            <h1 className="text-4xl font-bold text-gray-900 dark:text-white mb-4">
              Welcome to {appName} Installation
            </h1>
            <p className="text-lg text-gray-600 dark:text-gray-400">
              Let's get your application up and running in just a few simple steps
            </p>
          </motion.div>

          {/* Main Card */}
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ delay: 0.2 }}
          >
            <Card className="backdrop-blur-sm bg-white/90 dark:bg-gray-800/90 shadow-xl border-0">
              <CardContent className="p-8">
                {/* Features Grid */}
                <div className="grid md:grid-cols-2 gap-6 mb-8">
                  {features.map((feature, index) => (
                    <motion.div
                      key={index}
                      initial={{ opacity: 0, x: -20 }}
                      animate={{ opacity: 1, x: 0 }}
                      transition={{ delay: 0.3 + index * 0.1 }}
                      className="flex items-start space-x-4"
                    >
                      <div className="flex-shrink-0">
                        <div className="w-12 h-12 rounded-lg bg-gradient-to-r from-blue-500 to-purple-600 flex items-center justify-center">
                          <feature.icon className="w-6 h-6 text-white" />
                        </div>
                      </div>
                      <div>
                        <h3 className="font-semibold text-gray-900 dark:text-white mb-1">
                          {feature.title}
                        </h3>
                        <p className="text-sm text-gray-600 dark:text-gray-400">
                          {feature.desc}
                        </p>
                      </div>
                    </motion.div>
                  ))}
                </div>

                {/* Installation Steps Preview with Progress */}
                <div className="bg-gray-50 dark:bg-gray-900/50 rounded-lg p-6 mb-8">
                  <h3 className="font-semibold text-gray-900 dark:text-white mb-4">
                    Installation Process
                  </h3>

                  {/* Progress Bar */}
                  <div className="mb-6">
                    <div className="flex items-center justify-between mb-2">
                      <span className="text-sm text-gray-600 dark:text-gray-400">Ready to Install</span>
                      <span className="text-sm font-medium text-blue-600 dark:text-blue-400">0%</span>
                    </div>
                    <div className="w-full bg-gray-200 rounded-full h-2 dark:bg-gray-700 overflow-hidden">
                      <div className="bg-gradient-to-r from-blue-500 to-purple-600 h-2 rounded-full transition-all duration-500" style={{ width: '0%' }}></div>
                    </div>
                  </div>

                  {/* Steps List with Percentage */}
                  <div className="space-y-3">
                    {[
                      { step: "System Requirements Check", percentage: "17%" },
                      { step: "Database Configuration", percentage: "33%" },
                      { step: "License Verification", percentage: "50%" },
                      { step: "Admin Account Setup", percentage: "67%" },
                      { step: "Installation & Setup", percentage: "83%" },
                      { step: "Complete", percentage: "100%" }
                    ].map((item, index) => (
                      <motion.div
                        key={index}
                        initial={{ opacity: 0, x: -20 }}
                        animate={{ opacity: 1, x: 0 }}
                        transition={{ delay: 0.3 + index * 0.05 }}
                        className="flex items-center justify-between group hover:bg-white dark:hover:bg-gray-800 rounded-lg p-2 transition-colors"
                      >
                        <div className="flex items-center space-x-3">
                          <div className="w-8 h-8 rounded-full bg-gradient-to-r from-blue-500 to-purple-600 flex items-center justify-center text-white text-sm font-semibold group-hover:scale-110 transition-transform">
                            {index + 1}
                          </div>
                          <span className="text-gray-700 dark:text-gray-300">{item.step}</span>
                        </div>
                        <span className="text-xs text-gray-500 dark:text-gray-400 font-medium">{item.percentage}</span>
                      </motion.div>
                    ))}
                  </div>
                </div>

                {/* Action Button */}
                <Button
                  onClick={handleStart}
                  disabled={isLoading}
                  className="w-full h-12 text-lg font-semibold bg-gradient-to-r from-blue-500 to-purple-600 hover:from-blue-600 hover:to-purple-700 text-white"
                >
                  {isLoading ? (
                    <span className="flex items-center justify-center">
                      <svg className="animate-spin -ml-1 mr-3 h-5 w-5 text-white" fill="none" viewBox="0 0 24 24">
                        <circle className="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" strokeWidth="4"></circle>
                        <path className="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                      </svg>
                      Starting Installation...
                    </span>
                  ) : (
                    <span className="flex items-center justify-center">
                      Start Installation
                      <ArrowRight className="ml-2 h-5 w-5" />
                    </span>
                  )}
                </Button>

                {/* Footer Note */}
                <p className="text-center text-sm text-gray-500 dark:text-gray-400 mt-6">
                  Please ensure you have proper backup before installation
                </p>
              </CardContent>
            </Card>
          </motion.div>
        </div>
      </div>
    </div>
  )
}