<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Core\Setting;

class TestThemeSettings extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'test:theme-settings';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Test theme settings loading from database and config';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Testing Theme Settings...');
        $this->newLine();

        // Test site_settings function
        $this->info('=== Testing site_settings() function ===');
        $themeColors = [
            'primary_color',
            'secondary_color',
            'primary_color_text',
            'secondary_color_text',
            'body_text_primary',
            'body_text_secondary'
        ];

        foreach ($themeColors as $color) {
            $value = site_settings($color);
            $this->line("site_settings('{$color}'): " . ($value ?: 'NULL'));
        }

        $this->newLine();

        // Test direct database query
        $this->info('=== Testing direct database query ===');
        try {
            $settings = Setting::whereIn('key', $themeColors)->pluck('value', 'key');

            foreach ($themeColors as $color) {
                $value = $settings->get($color);
                $this->line("Database '{$color}': " . ($value ?: 'NULL'));
            }
        } catch (\Exception $e) {
            $this->error('Database query failed: ' . $e->getMessage());
        }

        $this->newLine();

        // Test config fallbacks
        $this->info('=== Testing config fallbacks ===');
        foreach ($themeColors as $color) {
            $value = config("site_settings.{$color}");
            $this->line("Config '{$color}': " . ($value ?: 'NULL'));
        }

        $this->newLine();

        // Test settings count
        $totalSettings = Setting::count();
        $this->info("Total settings in database: {$totalSettings}");

        // Test settings that exist
        $existingThemeSettings = Setting::whereIn('key', $themeColors)->count();
        $this->info("Theme settings in database: {$existingThemeSettings} / " . count($themeColors));

        $this->newLine();
        $this->info('Theme settings test completed!');

        return 0;
    }
}