<?php

namespace App\Console\Commands;

use App\Services\LicenseService;
use Illuminate\Console\Command;

class VerifyLicense extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'license:verify {--force : Force verification even if not due}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Verify application license with Envato';

    /**
     * Execute the console command.
     */
    public function handle(LicenseService $licenseService)
    {
        $this->info('Starting license verification...');

        try {
            $result = $licenseService->periodicVerification();

            if ($result) {
                $this->info('✓ License verification successful');
                return Command::SUCCESS;
            } else {
                $this->warn('✗ License verification failed');
                $this->warn('The system will continue to operate during the grace period.');
                return Command::FAILURE;
            }
        } catch (\Exception $e) {
            $this->error('License verification error: ' . $e->getMessage());
            return Command::FAILURE;
        }
    }
}
