<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AiTemplateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'platform_id' => 'required|integer|exists:platforms,id',
            'prompt' => 'required|string',

        ];
    }

    public function messages(): array
    {
        return [
            'name.required' => 'The template name is required.',
            'name.string' => 'The template name must be a valid string.',
            'name.max' => 'The template name may not be greater than 255 characters.',

            'platform_id.required' => 'Please select a platform.',
            'platform_id.integer' => 'Invalid platform identifier.',
            'platform_id.exists' => 'The selected platform is invalid.',

            'prompt.required' => 'A prompt is required.',
            'prompt.string' => 'The prompt must be text.',
        ];
    }
}
