<?php

namespace App\Http\Requests\Auth;

use App\Enums\StatusEnum;
use App\Http\Services\Auth\AuthService;
use Illuminate\Foundation\Http\FormRequest;

class AuthenticateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {

        $rules =  [
            'loginIdentifier' => ['required','max:155'],
            'password' => ['required','max:155']
        ];

        if((new AuthService())->loginWithOtp()){
            unset($rules['password']);
        }

        return $rules;
    }
}
