<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PostTemplateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'nullable|string|max:255',
            'description' => 'nullable|string|max:1000',
            'content' => 'required|string',
            'link' => 'nullable|string',
            'platform_id' => 'nullable|integer|exists:platforms,id',

            'files' => 'nullable|array',
            'files.*.id' => 'required|integer|exists:files,id',
            'files.*.caption' => 'nullable|string|max:255',
            'files.*.alt' => 'nullable|string|max:255',
            'files.*.order' => 'nullable|integer|min:0',
        ];
    }
}
